<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @copyright (c) 2010 phpBB.it
* @copyright (c) 2014 phpBBItalia.net <http://www.phpbbitalia.net>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'Accedendo a “%1$s” (in seguito “noi”, “nostro”, “%1$s”, “%2$s”), l’utente accetta di essere vincolato legalmente alle seguenti condizioni d’uso. Se non accetti di essere limitato legalmente dalle condizioni d’uso seguenti non utilizzare i servizi offerti da “%1$s”. Le condizioni d’uso possono cambiare in qualunque momento, sarà nostra premura avvisarti di tali modifiche, benché sia opportuno controllare con frequenza queste pagine per eventuali modifiche, dato che l’uso dei servizi di “%1$s” implica la completa accettazione delle condizioni d’uso.<br />
	<br />
	“%1$s” utilizza il sistema phpBB (in seguito “loro”, “phpBB software”, “www.phpbb.com”, “phpBB Limited”, “phpBB Teams”) che è un software per la creazione di comunità web rilasciata sotto “<a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License v2</a>” (in seguito “GPL”) liberamente scaricabile da <a href="https://www.phpbb.com/">www.phpbb.com</a>. Il software phpBB facilita le aree di discussione internet; phpBB Limited non è responsabile dei contenuti e della gestione. Per ulteriori informazioni su phpBB: <a href="https://www.phpbb.com">https://www.phpbb.com</a>.<br />
	<br />
	Accetti di non inviare alcun tipo di offesa, oscenità, volgarità, calunnia, minaccia, messaggio a sfondo sessuale, o qualsiasi altro tipo di materiale che può violare una qualsiasi Legge del proprio Stato, o dello Stato dove “%1$s” è ospitato, o di una Legge internazionale. Fare ciò porta all’immediato e permanente divieto di accesso, con notifica al tuo provider Internet se è ritenuto da noi opportuno. Tutti gli indirizzi IP sono registrati per salvaguardare e rinforzare queste condizioni. Accetti che “%1$s” abbia il diritto di rimuovere, riscrivere, spostare o chiudere qualsiasi argomento in qualsiasi momento lo ritenga necessario. Come fruitore di questo servizio, accetti che ogni informazione (dato personale) tu abbia inviato sia conservata in un database. Al contempo queste informazioni non saranno divulgate a nessuno senza il tuo consenso, né “%1$s” o phpBB sono da ritenersi responsabili per qualsiasi violazione al sistema che possa compromettere queste informazioni.
	',

	'PRIVACY_POLICY'		=> 'Questo paragrafo spiega dettagliatamente come “%1$s” ed eventuali affiliati (in seguito “noi”, “nostro”, “%1$s”, “%2$s”) e phpBB (in seguito “essi”, “loro”, “phpBB software”, “www.phpbb.com”, “phpBB Limited”, “phpBB Teams”) usano le informazioni raccolte durante qualsiasi sessione d’uso da te effettuata (in seguito “le tue informazioni”).<br />
	<br />
	Le tue informazioni sono raccolte in due modi. In primo luogo, mentre si naviga su “%1$s” il software phpBB creerà un certo numero di cookie, che sono piccoli file di testo che vengono scaricati nei file temporanei del tuo browser. I primi due cookie contengono solo un identificativo utente (in seguito “user-id”) ed un identificativo anonimo di sessione (in seguito “session-id”), assegnato automaticamente dal software phpBB. Un terzo cookie viene creato quando si naviga tra gli argomenti di “%1$s” e viene usato per memorizzare gli argomenti letti da quelli ancora da leggere, quindi agevolando la lettura nelle tue visite future.<br />
	<br />
	Possiamo anche generare cookie esterni al software phpBB mentre navighi su “%1$s”, benché questi siano estranei agli scopi di questo documento che intende trattare solo quelli creati dal software phpBB. Il secondo metodo di raccolta delle tue informazioni è dato da quello che tu inserisci volontariamente. Con questo sono intesi e non limitati ad essi: inviare messaggi come utente ospite (in seguito “messaggi da ospite”), registrarsi su “%1$s” (in seguito “il tuo account”) e l’invio di messaggi dopo la registrazione e l’accesso (in seguito “i tuoi messaggi”).<br />
	<br />
	Il tuo account avrà, di base, un unico nome identificativo (in seguito “il tuo nome utente”), una password da usare per accedere al tuo account (in seguito “la tua password”) ed un indirizzo email valido (in seguito “la tua email”). Le informazioni rilasciate per l’apertura dell’account su “%1$s” sono protette dalle Leggi sulla Privacy dello Stato che ospita il server. In aggiunta alle informazioni di nome utente, password ed indirizzo email richiesti durante il processo di registrazione su “%1$s”, quale altra informazione sia obbligatoria o opzionale, è a totale discrezione di “%1$s”. In tutti i casi, hai la possibilità di selezionare quali delle informazioni che hai fornito possano essere rese pubbliche. All’interno del tuo account, hai facoltà di opt-in o opt-out sul generatore automatico di email del software phpBB.<br /><br />
	La password viene criptata (hash unidirezionale) per motivi di sicurezza. In ogni caso ti raccomandiamo di non utilizzare la stessa password in troppi siti. La tua password è il metodo di accesso al tuo account su “%1$s”, quindi proteggila attentamente. Ricorda che in nessuna circostanza affiliati di “%1$s”, phpBB o terzi possono legittimamente richiedere la tua password. Nel caso dimenticassi la tua password, puoi utilizzare l’opzione “Ho dimenticato la password” prevista dal software phpBB. Durante questo procedimento ti verrà richiesto il tuo nome utente ed indirizzo email, in modo che il software phpBB possa generare una nuova password che ti permetterà di accedere nuovamente al tuo account.',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'				=> 'Il tuo account è stato attivato. Grazie per esserti registrato.',
	'ACCOUNT_ACTIVE_ADMIN'			=> 'L’account è stato attivato.',
	'ACCOUNT_ACTIVE_PROFILE'		=> 'Il tuo account è stato riattivato.',
	'ACCOUNT_ADDED'					=> 'Grazie per esserti registrato, il tuo account è stato creato. Ora puoi accedere usando il tuo nome utente e password.',
	'ACCOUNT_COPPA'					=> 'Il tuo account è stato creato ma deve essere approvato; controlla i dettagli sul tuo indirizzo di posta elettronica.',
	'ACCOUNT_EMAIL_CHANGED'			=> 'Il tuo account è stato aggiornato. Tuttavia, il sistema richiede la riattivazione dell’account per il cambio di indirizzo email. Una chiave di attivazione è stata inviata al nuovo indirizzo che hai fornito. Controlla la tua posta per maggiori informazioni.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'Il tuo account è stato aggiornato. Tuttavia, il sistema richiede la riattivazione dell’account da parte di un amministratore per il cambio di indirizzo email. Un’email è stata inviata agli amministratori e verrai informato quando il tuo account sarà riattivato.',
	'ACCOUNT_INACTIVE'				=> 'Il tuo account è stato creato. Tuttavia, il sistema richiede l’attivazione dell’account; una chiave di attivazione è stata inviata all’indirizzo email che hai fornito. Controlla la tua posta per maggiori informazioni.',
	'ACCOUNT_INACTIVE_ADMIN'		=> 'Il tuo account è stato creato. Tuttavia, il sistema richiede l’attivazione dell’account da parte di un amministratore. Un’email è stata inviata agli amministratori; verrai informato quando il tuo account sarà attivato.',
	'ACTIVATION_EMAIL_SENT'			=> 'L’email di attivazione è stata inviata al tuo indirizzo di posta elettronica.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'L’email di attivazione è stata inviata agli indirizzi di posta elettronica degli amministratori.',
	'ADD'							=> 'Aggiungi',
	'ADD_BCC'						=> 'Aggiungi [CCN]',
	'ADD_FOES'						=> 'Aggiungi nuovi ignorati',
	'ADD_FOES_EXPLAIN'				=> 'Puoi inserire più nomi utente, uno per linea.',
	'ADD_FOLDER'					=> 'Aggiungi cartella',
	'ADD_FRIENDS'					=> 'Aggiungi nuovi amici',
	'ADD_FRIENDS_EXPLAIN'			=> 'Puoi inserire più nomi utente, uno per linea.',
	'ADD_NEW_RULE'					=> 'Aggiungi nuova regola',
	'ADD_RULE'						=> 'Aggiungi regola',
	'ADD_TO'						=> 'Aggiungi [A]',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Qui è possibile aggiungere nuovi utenti al gruppo. È possibile scegliere se gli utenti selezionati devono essere predefiniti a questo gruppo. Si prega di inserire ciascun nome utente su una linea separata.',
	'ADMIN_EMAIL'					=> 'Gli amministratori possono inviarti email',
	'AGREE'							=> 'Accetto queste condizioni d’uso',
	'ALLOW_PM'						=> 'Gli utenti possono inviarti messaggi privati',
	'ALLOW_PM_EXPLAIN'				=> 'Amministratori e moderatori potranno sempre inviarti messaggi.',
	'ALREADY_ACTIVATED'				=> 'Hai già attivato il tuo account.',
	'ATTACHMENTS_EXPLAIN'			=> 'Questa è la lista di allegati che hai aggiunto ai messaggi.',
	'ATTACHMENTS_DELETED'			=> 'Gli allegati sono stati cancellati.',
	'ATTACHMENT_DELETED'			=> 'L’allegato è stato cancellato.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'	=> 'Le chiavi d’accesso selezionate con "Ricordami" sono state cancellate con successo',
	'AVATAR_CATEGORY'				=> 'Categoria',
	'AVATAR_DRIVER_GRAVATAR_TITLE'	=> 'Gravatar',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'=> 'Gravatar è un servizio che ti permette di mantenere il tuo avatar su più siti web. Visita <a href="http://www.gravatar.com/">Gravatar</a> per avere maggiori informazioni.',
	'AVATAR_DRIVER_LOCAL_TITLE'		=> 'Galleria avatar',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'	=> 'Puoi scegliere il tuo avatar tra quelli disponibili da un set predefinito.',
	'AVATAR_DRIVER_REMOTE_TITLE'	=> 'Avatar remoto',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'	=> 'Link ad un avatar proveniente da un altro sito.',
	'AVATAR_DRIVER_UPLOAD_TITLE'	=> 'Carica avatar',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'	=> 'Carica il tuo avatar personalizzato.',
	'AVATAR_EXPLAIN'				=> 'Dimensioni massime; larghezza: %1$s, altezza: %2$s, peso del file: %3$.2f KiB.',
	'AVATAR_FEATURES_DISABLED'		=> 'L’inserimento degli avatar è disabilitato.',
	'AVATAR_GALLERY'				=> 'Galleria locale',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'Impossibile caricare avatar su %s.',
	'AVATAR_NOT_ALLOWED'			=> 'Il tuo avatar non può essere visualizzato perché gli avatar sono stati disabilitati.',
	'AVATAR_PAGE'					=> 'Pagina',
	'AVATAR_SELECT'					=> 'Seleziona il tuo avatar',
	'AVATAR_TYPE'					=> 'Tipo di Avatar',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'Il tuo avatar attuale non può essere visualizzato perché il suo tipo è stato disabilitato.',

	'BACK_TO_DRAFTS'			=> 'Torna a bozze salvate',
	'BACK_TO_LOGIN'				=> 'Torna alla schermata di accesso',
	'BIRTHDAY'					=> 'Compleanno',
	'BIRTHDAY_EXPLAIN'			=> 'Inserendo l’anno, la tua età verrà indicata al tuo compleanno.',
	'BOARD_DATE_FORMAT'			=> 'Formato data',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'La sintassi della data è uguale alla funzione <a href="http://www.php.net/date">date()</a> del PHP.',
	'BOARD_LANGUAGE'			=> 'Lingua',
	'BOARD_STYLE'				=> 'Stile',
	'BOARD_TIMEZONE'			=> 'Fuso orario',
	'BOOKMARKS'					=> 'Segnalibri',
	'BOOKMARKS_EXPLAIN'			=> 'Puoi inserire segnalibri agli argomenti per rivederli in futuro. Seleziona nella lista i segnalibri che vuoi cancellare, poi clicca <em>Rimuovi segnalibri selezionati</em>.',
	'BOOKMARKS_DISABLED'		=> 'I segnalibri non sono attivi.',
	'BOOKMARKS_REMOVED'			=> 'I segnalibri sono stati rimossi.',

	'CANNOT_EDIT_MESSAGE_TIME'			=> 'Non è più possibile modificare o cancellare quel messaggio.',
	'CANNOT_MOVE_TO_SAME_FOLDER'		=> 'I messaggi non possono essere spostati nella cartella che vuoi rimuovere.',
	'CANNOT_MOVE_FROM_SPECIAL'			=> 'I messaggi non possono essere spostati nella cartella posta in uscita.',
	'CANNOT_RENAME_FOLDER'				=> 'Questa cartella non può essere rinominata.',
	'CANNOT_REMOVE_FOLDER'				=> 'Questa cartella non può essere rimossa.',
	'CHANGE_DEFAULT_GROUP'				=> 'Cambia gruppo predefinito',
	'CHANGE_PASSWORD'					=> 'Cambia password',
	'CLICK_GOTO_FOLDER'					=> '%1$sVai alla tua “%3$s” cartella%2$s',
	'CLICK_RETURN_FOLDER'				=> '%1$sRitorna alla tua cartella “%3$s”%2$s',
	'CONFIRMATION'						=> 'Conferma di registrazione',
	'CONFIRM_CHANGES'					=> 'Conferma variazioni',
	'CONFIRM_EXPLAIN'					=> 'Per impedire registrazioni automatiche il sistema richiede l’inserimento di un codice di conferma. Il codice è visualizzato nell’immagine che dovresti vedere qui sotto. Se per qualsiasi motivo non riuscissi a leggere il codice contatta un %samministratore%s.',
	'VC_REFRESH'						=> 'Ricarica il codice di conferma',
	'VC_REFRESH_EXPLAIN'				=> 'Se non riesci a leggere il codice puoi richiederne un altro cliccando il pulsante.',

	'CONFIRM_PASSWORD'					=> 'Conferma password',
	'CONFIRM_PASSWORD_EXPLAIN'			=> 'Devi confermare la password solo se l’hai cambiata sopra.',
	'COPPA_BIRTHDAY'					=> 'Per continuare la procedura di registrazione, specifica quando sei nato:',
	'COPPA_COMPLIANCE'					=> 'Adeguamento COPPA',
	'COPPA_EXPLAIN'						=> 'Cliccando Invia il tuo account verrà creato. Tuttavia non potrà essere attivato fintanto che un genitore o il tutore approvi la tua registrazione. Ti verrà inviato via email il modulo da compilare ed i dettagli di dove inviarlo.',
	'CREATE_FOLDER'						=> 'Aggiungi cartella…',
	'CURRENT_IMAGE'						=> 'Immagine attuale',
	'CURRENT_PASSWORD'					=> 'Password attuale',
	'CURRENT_PASSWORD_EXPLAIN'			=> 'È necessario inserire la password attuale per modificare l’indirizzo email o il nome utente.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN'	=> 'È necessario inserire la password attuale per modificare la stessa password, l’indirizzo email o il nome utente.',
	'CUR_PASSWORD_EMPTY'				=> 'Non hai inserito la password attuale.',
	'CUR_PASSWORD_ERROR'				=> 'La password attuale inserita non è corretta.',
	'CUSTOM_DATEFORMAT'					=> 'Personalizza…',

	'DEFAULT_ACTION'			=> 'Azione predefinita',
	'DEFAULT_ACTION_EXPLAIN'	=> 'Questa azione verrà eseguita nel caso in cui nessuna delle precedenti sia applicabile.',
	'DEFAULT_ADD_SIG'			=> 'Mostra sempre la mia firma',
	'DEFAULT_BBCODE'			=> 'Attiva sempre il BBCode',
	'DEFAULT_NOTIFY'			=> 'Avvertimi sempre quando viene scritta una risposta',
	'DEFAULT_SMILIES'			=> 'Visualizza sempre le emoticon',
	'DEFINED_RULES'				=> 'Regole definite',
	'DELETED_TOPIC'				=> 'L’argomento è stato cancellato',
	'DELETE_ATTACHMENT'			=> 'Cancella allegato',
	'DELETE_ATTACHMENTS'		=> 'Cancella allegati',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'Sei sicuro di voler cancellare l’allegato?',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Sei sicuro di voler cancellare gli allegati?',
	'DELETE_AVATAR'				=> 'Cancella immagine',
	'DELETE_COOKIES_CONFIRM'	=> 'Sei sicuro di volere cancellare tutti i cookie di questa Board?',
	'DELETE_MARKED_PM'			=> 'Cancella i messaggi selezionati',
	'DELETE_MARKED_PM_CONFIRM'	=> 'Sei sicuro di voler cancellare tutti i messaggi selezionati?',
	'DELETE_OLDEST_MESSAGES'	=> 'Cancella i messaggi più vecchi',
	'DELETE_MESSAGE'			=> 'Cancella messaggio',
	'DELETE_MESSAGE_CONFIRM'	=> 'Sei sicuro di voler cancellare questo messaggio privato?',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'Cancella tutti i messaggi dalla cartella rimossa',
	'DELETE_RULE'				=> 'Cancella regola',
	'DELETE_RULE_CONFIRM'		=> 'Sei sicuro di voler cancellare questa regola?',
	'DEMOTE_SELECTED'			=> 'Cedi gestione selezionati',
	'DISABLE_CENSORS'			=> 'Attiva censura parole',
	'DISPLAY_GALLERY'			=> 'Visualizza galleria',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'L’indirizzo email inserito non ha un dominio valido.',
	'DOWNLOADS'					=> 'Download',
	'DRAFTS_DELETED'			=> 'Tutte le bozze selezionate sono state cancellate.',
	'DRAFTS_EXPLAIN'			=> 'Qui puoi leggere, modificare e cancellare le bozze dei tuoi messaggi.',
	'DRAFT_UPDATED'				=> 'La bozza è stata aggiornata.',

	'EDIT_DRAFT_EXPLAIN'		=> 'Qui puoi modificare la tua bozza. Le bozze non contengono allegati e dati di sondaggio.',
	'EMAIL_BANNED_EMAIL'		=> 'L’email inserita non può essere usata.',
	'EMAIL_REMIND'				=> 'Deve essere l’indirizzo email che hai inserito durante la registrazione.',
	'EMAIL_TAKEN_EMAIL'			=> 'L’indirizzo email inserito è già in uso.',
	'EMPTY_DRAFT'				=> 'Devi inserire un messaggio per apportare cambiamenti.',
	'EMPTY_DRAFT_TITLE'			=> 'Devi inserire un titolo per la bozza.',
	'EXPORT_AS_XML'				=> 'Esporta come XML',
	'EXPORT_AS_CSV'				=> 'Esporta come CSV',
	'EXPORT_AS_CSV_EXCEL'		=> 'Esporta come CSV (Excel)',
	'EXPORT_AS_TXT'				=> 'Esporta come TXT',
	'EXPORT_AS_MSG'				=> 'Esporta come MSG',
	'EXPORT_FOLDER'				=> 'Esporta come visualizzato',

	'FIELD_REQUIRED'						=> 'Il campo “%s” deve essere completato.',
	'FIELD_TOO_SHORT'						=> array(
		1	=> 'Il campo “%2$s” è troppo corto, è richiesto un minimo di %1$d carattere.',
		2	=> 'Il campo “%2$s” è troppo corto, è richiesto un minimo di %1$d caratteri.',
	),
	'FIELD_TOO_LONG'						=> array(
		1	=> 'Il campo “%2$s” è troppo lungo, è consentito un massimo di %1$d carattere.',
		2	=> 'Il campo “%2$s” è troppo lungo, è consentito un massimo di %1$d caratteri.',
	),
	'FIELD_TOO_SMALL'						=> 'Il valore di “%2$s” è troppo piccolo, è richiesto un valore minimo di %1$d.',
	'FIELD_TOO_LARGE'						=> 'Il valore di “%2$s” è troppo grande, è consentito un valore massimo di %1$d.',
	'FIELD_INVALID_CHARS_INVALID'			=> 'Il campo “%s” contiene caratteri non validi.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo numeri.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o punti.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION'	=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o _,-. , e il primo carattere deve essere una lettera.',
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici, spazio o -+_[].',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'	=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o _ .',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'	=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o punti.',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'	=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'	=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o _,-. e il primo carattere deve essere alfabetico.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici, spazi o -+_[].',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'		=> 'Il campo “%s” contiene caratteri non validi, sono ammessi solo caratteri alfanumerici o _ .',
	'FIELD_INVALID_DATE'					=> 'Il campo “%s” riporta una data non valida.',
	'FIELD_INVALID_URL'						=> 'Il campo “%s” contiene una URL non valido.',
	'FIELD_INVALID_VALUE'					=> 'Il campo “%s” ha un valore non valido.',

	'FOE_MESSAGE'				=> 'Messaggio da ignorato',
	'FOES_EXPLAIN'				=> 'Gli ignorati sono utenti che non vengono presi in considerazione. I messaggi di questi utenti non saranno completamente visibili. I messaggi privati sono comunque permessi. Tieni presente che non puoi ignorare moderatori o amministratori.',
	'FOES_UPDATED'				=> 'La lista ignorati è stata aggiornata.',
	'FOLDER_ADDED'				=> 'La cartella è stata aggiunta.',
	'FOLDER_MESSAGE_STATUS'		=> array(
		1	=> '%2$d di %1$s memorizzati',
		2	=> '%2$d di %1$s memorizzati',
	),
	'FOLDER_NAME_EMPTY'			=> 'È necessario inserire un nome per questa cartella',
	'FOLDER_NAME_EXIST'			=> 'La cartella <strong>%s</strong> esiste già.',
	'FOLDER_OPTIONS'			=> 'Opzioni cartella',
	'FOLDER_RENAMED'			=> 'La cartella è stata rinominata.',
	'FOLDER_REMOVED'			=> 'La cartella è stata rimossa.',
	'FOLDER_STATUS_MSG'			=> array(
		1	=> 'La cartella è piena al %3$d%% (%2$d di %1$s memorizzati)',
		2	=> 'La cartella è piena al %3$d%% (%2$d di %1$s memorizzati)',
	),
	'FORWARD_PM'				=> 'Inoltra MP',
	'FORCE_PASSWORD_EXPLAIN'	=> 'Prima di poter continuare a consultare i forum devi cambiare password.',
	'FRIEND_MESSAGE'			=> 'Messaggio da amico',
	'FRIENDS'					=> 'Amici',
	'FRIENDS_EXPLAIN'			=> 'La funzione Amici permette un accesso veloce agli utenti con cui comunichi frequentemente. Se il template è predisposto, ogni messaggio fatto da un amico sarà evidenziato.',
	'FRIENDS_OFFLINE'			=> 'OffLine',
	'FRIENDS_ONLINE'			=> 'OnLine',
	'FRIENDS_UPDATED'			=> 'La lista amici è stata aggiornata.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'L’azione da intraprendere quando la cartella è piena, è stata modificata.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- Messaggio originale --------',
	'FWD_SUBJECT'				=> 'Titolo: %s',
	'FWD_DATE'					=> 'Data: %s',
	'FWD_FROM'					=> 'Da: %s',
	'FWD_TO'					=> 'A: %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'Annuncio globale',

	'GRAVATAR_AVATAR_EMAIL'			=> 'Gravatar email',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'	=> 'Inserisci l’indirizzo email che hai utilizzato per la registrazione del tuo account su <a href="http://www.gravatar.com/">Gravatar</a>.',
	'GRAVATAR_AVATAR_SIZE'			=> 'Dimensione avatar',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'	=> 'Inserisci altezza e larghezza dell’avatar; lascia in bianco per tentare una verifica automatica.',

	'HIDE_ONLINE'				=> 'Accedi come utente nascosto',
	'HIDE_ONLINE_EXPLAIN'		=> 'La modifica sarà effettiva al tuo prossimo accesso al sistema.',
	'HOLD_NEW_MESSAGES'			=> 'Non accettare nuovi messaggi (i nuovi messaggi saranno trattenuti finché mancherà lo spazio necessario)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'Nessun messaggio sarà trattenuto',

	'IF_FOLDER_FULL'			=> 'Se la cartella è piena',
	'IMPORTANT_NEWS'			=> 'Annunci globali',
	'INVALID_USER_BIRTHDAY'		=> 'La data del compleanno non è stata inserita correttamente.',
	'INVALID_CHARS_USERNAME'	=> 'Il nome utente contiene caratteri non consentiti.',
	'INVALID_CHARS_NEW_PASSWORD'=> 'La password non contiene i caratteri richiesti.',
	'ITEMS_REQUIRED'			=> 'Le voci contrassegnate con * sono campi del profilo obbligatori che devono essere compilati.',

	'JOIN_SELECTED'				=> 'Aderisci a selezionati',

	'LANGUAGE'					=> 'Lingua',
	'LINK_REMOTE_AVATAR'		=> 'Collegamento esterno',
	'LINK_REMOTE_AVATAR_EXPLAIN'=> 'Inserisci il percorso URL dove risiede l’immagine dell’avatar che intendi utilizzare.',
	'LINK_REMOTE_SIZE'			=> 'Dimensioni avatar',
	'LINK_REMOTE_SIZE_EXPLAIN'	=> 'Specifica larghezza ed altezza dell’avatar; lascia vuoto per provare la verifica automatica.',
	'LOGIN_EXPLAIN_UCP'			=> 'Devi essere connesso per accedere al Pannello di Controllo Utente.',
	'LOGIN_LINK'				=> 'Collega o registra il tuo account su un servizio esterno con l’account della tua Board',
	'LOGIN_LINK_EXPLAIN'		=> 'Hai provato a connetterti con un account che non è ancora collegato ad un account di questa Board. Devi collegarlo ad un account esistente o crearne uno nuovo.',
	'LOGIN_LINK_MISSING_DATA'		=> 'I dati necessari per collegare il tuo account ad un servizio esterno non sono disponibili. Ripeti il processo di login.',
	'LOGIN_LINK_NO_DATA_PROVIDED'	=> 'Nessun dato è stato fornito in questa pagina al fine di collegare l’account del Forum ad un account esterno. Contatta l’amministratore della Board se riscontri problemi.',
	'LOGIN_KEY'					=> 'Chiave login',
	'LOGIN_TIME'				=> 'Ora login',
	'LOGIN_REDIRECT'			=> 'Accesso effettuato.',
	'LOGOUT_FAILED'				=> 'Non sei stato disconnesso, perché la richiesta non coincide con la sessione. Contatta un amministratore se dovesse ripresentarsi il problema.',
	'LOGOUT_REDIRECT'			=> 'Disconnessione effettuata.',

	'MARK_IMPORTANT'				=> 'Evidenzia come importante',
	'MARKED_MESSAGE'				=> 'Messaggio in evidenza',
	'MAX_FOLDER_REACHED'			=> 'Numero massimo di cartelle permesse raggiunto.',
	'MESSAGE_BY_AUTHOR'				=> 'da',
	'MESSAGE_COLOURS'				=> 'Colori messaggio',
	'MESSAGE_DELETED'				=> 'Il messaggio è stato cancellato.',
	'MESSAGE_EDITED'				=> 'Il messaggio è stato modificato.',
	'MESSAGE_HISTORY'				=> 'Storico messaggio',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'Il messaggio è stato rimosso dall’autore.',
	'MESSAGE_SENT_ON'				=> 'il',
	'MESSAGE_STORED'				=> 'Il messaggio è stato inviato.',
	'MESSAGE_TO'					=> 'A',
	'MESSAGES_DELETED'				=> 'I messaggi sono stati cancellati',
	'MOVE_DELETED_MESSAGES_TO'		=> 'Sposta i messaggi della cartella rimossa in',
	'MOVE_DOWN'						=> 'Sposta giù',
	'MOVE_MARKED_TO_FOLDER'			=> 'Sposta evidenziati in %s',
	'MOVE_PM_ERROR'					=> array(
		1	=> 'C’è stato un errore spostando i messaggi alla nuova cartella; solo %2$d su %1$s messaggi è stato spostato.',
		2	=> 'C’è stato un errore spostando i messaggi alla nuova cartella; solo %2$d su %1$s messaggi sono stati spostati.',
	),
	'MOVE_TO_FOLDER'				=> 'Sposta nella cartella',
	'MOVE_UP'						=> 'Sposta su',

	'NEW_FOLDER_NAME'				=> 'Nuovo nome cartella',
	'NEW_PASSWORD'					=> 'Nuova password',
	'NEW_PASSWORD_CONFIRM_EMPTY'	=> 'Non hai inserito la password di conferma.',
	'NEW_PASSWORD_ERROR'			=> 'Le password che hai inserito non coincidono.',

	'NOTIFICATIONS_MARK_ALL_READ'						=> 'Segna tutte le notifiche come lette',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'				=> 'Sei sicuro di voler segnare tutte le notifiche come lette?',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'				=> 'Tutte le notifiche sono state segnate come lette.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'					=> 'Notifiche varie',
	'NOTIFICATION_GROUP_MODERATION'						=> 'Notifiche moderazione',
	'NOTIFICATION_GROUP_ADMINISTRATION'					=> 'Notifiche amministrative',
	'NOTIFICATION_GROUP_POSTING'						=> 'Notifiche messaggi',
	'NOTIFICATION_METHOD_EMAIL'							=> 'Email',
	'NOTIFICATION_METHOD_JABBER'						=> 'Jabber',
	'NOTIFICATION_TYPE'									=> 'Tipo di notifica',
	'NOTIFICATION_TYPE_BOOKMARK'						=> 'Qualcuno ha risposto ad un messaggio che hai aggiunto ai segnalibri',
	'NOTIFICATION_TYPE_GROUP_REQUEST'					=> 'Qualcuno ha richiesto l’aggiunta ad un gruppo che amministri',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'				=> 'Un messaggio o un argomento necessita di approvazione',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'				=> 'Il tuo argomento/messaggio è stato approvato o disapprovato da un moderatore',
	'NOTIFICATION_TYPE_PM'								=> 'Qualcuno ti ha inviato un messaggio privato',
	'NOTIFICATION_TYPE_POST'							=> 'Qualcuno ha risposto ad un argomento a cui sei iscritto',
	'NOTIFICATION_TYPE_QUOTE'							=> 'Qualcuno ti ha citato in un messaggio',
	'NOTIFICATION_TYPE_REPORT'							=> 'Qualcuno ha segnalato un messaggio',
	'NOTIFICATION_TYPE_TOPIC'							=> 'Un utente ha creato un argomento in un forum da te sottoscritto',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'				=> 'Un utente richiede attivazione',

	'NOTIFY_METHOD'					=> 'Metodo di avviso',
	'NOTIFY_METHOD_BOTH'			=> 'Entrambi',
	'NOTIFY_METHOD_EMAIL'			=> 'Solo email',
	'NOTIFY_METHOD_EXPLAIN'			=> 'Metodo per l’invio di messaggi email da questo sistema.',
	'NOTIFY_METHOD_IM'				=> 'Solo Jabber',
	'NOTIFY_ON_PM'					=> 'Avviso email per nuovi messaggi privati',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'Non puoi aggiungere utenti anonimi alla lista amici.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'Non puoi aggiungere Bot alla tua lista amici.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'Non puoi aggiungere utenti alla lista amici se già presenti in quella ignorati.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'Non puoi aggiungere te stesso alla lista amici.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'Non puoi aggiungere amministratori e moderatori nella lista ignorati.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'Non puoi aggiungere utenti anonimi alla lista ignorati.',
	'NOT_ADDED_FOES_BOTS'			=> 'Non puoi aggiungere Bot alla lista ignorati.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'Non puoi aggiungere utenti alla lista ignorati se già presenti in quella amici.',
	'NOT_ADDED_FOES_SELF'			=> 'Non puoi aggiungere te stesso alla lista utenti ignorati.',
	'NOT_AGREE'						=> 'Non accetto queste condizioni d’uso',
	'NOT_ENOUGH_SPACE_FOLDER'		=> 'La cartella di destinazione “%s” risulta piena. L’azione richiesta non è stata portata a termine.',
	'NOT_MOVED_MESSAGES'			=> array(
		1	=> 'Hai %d messaggio privato attualmente trattenuto a causa di cartella piena.',
		2	=> 'Hai %d messaggi privati attualmente trattenuti a causa di cartella piena.',
	),
	'NO_ACTION_MODE'				=> 'Nessuna azione specificata.',
	'NO_AUTHOR'						=> 'Nessun autore definito per questo messaggio',
	'NO_AVATAR'						=> 'Nessun avatar selezionato',
	'NO_AVATAR_CATEGORY'			=> 'Nessuna',

	'NO_AUTH_DELETE_MESSAGE'		=> 'Non sei autorizzato a cancellare messaggi privati.',
	'NO_AUTH_EDIT_MESSAGE'			=> 'Non sei autorizzato a modificare messaggi privati.',
	'NO_AUTH_FORWARD_MESSAGE'		=> 'Non sei autorizzato ad inoltrare messaggi privati.',
	'NO_AUTH_GROUP_MESSAGE'			=> 'Non sei autorizzato ad inviare messaggi privati ai gruppi.',
	'NO_AUTH_PASSWORD_REMINDER'		=> 'Non sei autorizzato a richiedere una nuova password.',
	'NO_AUTH_PROFILEINFO'			=> 'Non sei autorizzato a modificare le informazioni del tuo profilo.',
	'NO_AUTH_READ_HOLD_MESSAGE'		=> 'Non sei autorizzato a leggere i messaggi privati trattenuti.',
	'NO_AUTH_READ_MESSAGE'			=> 'Non sei autorizzato a leggere messaggi privati.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'Non puoi leggere questo messaggio perché è stato rimosso dall’autore.',
	'NO_AUTH_SEND_MESSAGE'			=> 'Non sei autorizzato ad inviare messaggi privati.',
	'NO_AUTH_SIGNATURE'				=> 'Non sei autorizzato a creare una firma.',

	'NO_BCC_RECIPIENT'			=> 'Nessuno',
	'NO_BOOKMARKS'				=> 'Non hai segnalibri.',
	'NO_BOOKMARKS_SELECTED'		=> 'Non hai selezionato alcun segnalibro.',
	'NO_EDIT_READ_MESSAGE'		=> 'Il messaggio privato non può essere modificato perché è già stato letto.',
	'NO_EMAIL_USER'				=> 'Le informazioni email o nome utente fornite non sono state trovate.',
	'NO_FOES'					=> 'Nessun utente ignorato definito',
	'NO_FRIENDS'				=> 'Nessun amico definito',
	'NO_FRIENDS_OFFLINE'		=> 'Nessun amico OffLine',
	'NO_FRIENDS_ONLINE'			=> 'Nessun amico OnLine',
	'NO_GROUP_SELECTED'			=> 'Nessun gruppo specificato.',
	'NO_IMPORTANT_NEWS'			=> 'Nessun annuncio globale presente.',
	'NO_MESSAGE'				=> 'Il messaggio privato non è stato trovato.',
	'NO_NEW_FOLDER_NAME'		=> 'Devi specificare un nuovo nome per la cartella.',
	'NO_NEWER_PM'				=> 'Nessun messaggio seguente.',
	'NO_OLDER_PM'				=> 'Nessun messaggio precedente.',
	'NO_PASSWORD_SUPPLIED'		=> 'Non puoi accedere senza una password.',
	'NO_RECIPIENT'				=> 'Nessun destinatario definito.',
	'NO_RULES_DEFINED'			=> 'Nessuna regola definita.',
	'NO_SAVED_DRAFTS'			=> 'Nessuna bozza salvata.',
	'NO_TO_RECIPIENT'			=> 'Nessuno',
	'NO_WATCHED_FORUMS'			=> 'Non stai controllando alcun forum.',
	'NO_WATCHED_SELECTED'		=> 'Non hai selezionato nessun argomento o forum controllato.',
	'NO_WATCHED_TOPICS'			=> 'Non stai controllando alcun argomento.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'La password deve essere lunga tra %1$s e %2$s, deve contenere numeri e lettere sia maiuscole che minuscole.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'Deve essere tra %1$s e %2$s.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'La password deve essere lunga tra %1$s e %2$s, deve contenere lettere sia maiuscole che minuscole.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'La password deve essere lunga tra %1$s e %2$s, deve contenere numeri, simboli e lettere sia maiuscole che minuscole.',
	'PASSWORD'					=> 'Password',
	'PASSWORD_ACTIVATED'		=> 'La tua nuova password è stata attivata.',
	'PASSWORD_UPDATED'			=> 'Una nuova password è stata inviata al tuo indirizzo email.',
	'PERMISSIONS_RESTORED'		=> 'Permessi originali ripristinati.',
	'PERMISSIONS_TRANSFERRED'	=> 'Permessi da <strong>%s</strong> trasferiti, ora puoi visitare il sistema con i permessi dell’utente.<br />I permessi di amministratore non sono stati trasferiti. Puoi ritornare ai tuoi permessi originali in ogni momento.',
	'PM_DISABLED'				=> 'I messaggi privati sono disabilitati.',
	'PM_FROM'					=> 'Da',
	'PM_FROM_REMOVED_AUTHOR'	=> 'Questo messaggio è stato spedito da un utente non più registrato.',
	'PM_ICON'					=> 'Icona MP',
	'PM_INBOX'					=> 'Messaggi in arrivo',
	'PM_MARK_ALL_READ'			=> 'Segna messaggi come già letti',
	'PM_MARK_ALL_READ_SUCCESS'	=> 'Tutti i messaggi privati in questa cartella sono stati segnati come già letti',
	'PM_NO_USERS'				=> 'Gli utenti da aggiungere richiesti non esistono.',
	'PM_OUTBOX'					=> 'Messaggi in uscita',
	'PM_SENTBOX'				=> 'Messaggi spediti',
	'PM_SUBJECT'				=> 'Messaggio',
	'PM_TO'						=> 'Invia a',
	'PM_TOOLS'					=> 'Strumenti per i messaggi',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'Alcuni utenti non possono essere aggiunti in quanto non hanno il permesso di leggere i messaggi privati​​.',
	'PM_USERS_REMOVED_NO_PM'	=> 'Alcuni utenti non sono stati aggiunti in quanto hanno disabilitato la ricezione dei messaggi privati.',
	'POST_EDIT_PM'				=> 'Modifica messaggio',
	'POST_FORWARD_PM'			=> 'Inoltra messaggio',
	'POST_NEW_PM'				=> 'Nuovo messaggio',
	'POST_PM_LOCKED'			=> 'L’invio di messaggi privati è bloccato.',
	'POST_PM_POST'				=> 'Riporta argomento',
	'POST_QUOTE_PM'				=> 'Riporta messaggio',
	'POST_REPLY_PM'				=> 'Rispondi al messaggio',
	'PRINT_PM'					=> 'Stampa',
	'PREFERENCES_UPDATED'		=> 'Le tue preferenze sono state aggiornate.',
	'PROFILE_INFO_NOTICE'		=> 'N.B. queste informazioni possono essere visibili ad altri utenti. Fai attenzione quando inserisci i tuoi dettagli personali. Ogni voce marcata con * deve essere completata.',
	'PROFILE_UPDATED'			=> 'Il tuo profilo è stato aggiornato.',
	'PROFILE_AUTOLOGIN_KEYS'	=> 'La chiave di login "Ricordami" ti collega automaticamente quando visiti la Board. Se ti disconnetti, la chiave è cancellata solo nel computer da cui ti disconnetti. Qui puoi vedere le chiavi da te create sugli altri computer che utilizzi per accedere.',
	'PROFILE_NO_AUTOLOGIN_KEYS'	=> 'Non ci sono sono chiavi "Ricordami" salvate.',

	'RECIPIENT'							=> 'Destinatario',
	'RECIPIENTS'						=> 'Destinatari',
	'REGISTRATION'						=> 'Registrazione',
	'RELEASE_MESSAGES'					=> '%sSblocca tutti i messaggi trattenuti%s… saranno indirizzati nelle cartelle appropriate se lo spazio lo consente.',
	'REMOVE_ADDRESS'					=> 'Rimuovi indirizzo',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Rimuovi segnalibri selezionati',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Sei sicuro di voler cancellare i segnalibri selezionati?',
	'REMOVE_BOOKMARK_MARKED'			=> 'Rimuovi segnalibro selezionato',
	'REMOVE_FOLDER'						=> 'Rimuovi cartella',
	'REMOVE_FOLDER_CONFIRM'				=> 'Sei sicuro di voler rimuovere questa cartella?',
	'RENAME'							=> 'Rinomina',
	'RENAME_FOLDER'						=> 'Rinomina cartella',
	'REPLIED_MESSAGE'					=> 'Risposto a messaggio',
	'REPLY_TO_ALL'						=> 'Rispondi al mittente e a tutti i destinatari.',
	'REPORT_PM'							=> 'Segnala il messaggio privato',
	'RESIGN_SELECTED'					=> 'Abbandona selezionato',
	'RETURN_FOLDER'						=> '%1$sRitorna alla cartella precedente%2$s',
	'RETURN_UCP'						=> '%sRitorna al Pannello di Controllo Utente%s',
	'RULE_ADDED'						=> 'La regola è stata aggiunta.',
	'RULE_ALREADY_DEFINED'				=> 'Questa regola era già stata definita.',
	'RULE_DELETED'						=> 'La regola è stata rimossa.',
	'RULE_LIMIT_REACHED'				=> 'Non è possibile aggiungere ulteriori regole ai Messaggi Privati. Hai raggiunto il numero massimo di regole consentito.',
	'RULE_NOT_DEFINED'					=> 'La regola non è stata definita correttamente.',
	'RULE_REMOVED_MESSAGES'				=> array(
		1	=> '%d messaggio privato è stato rimosso per i filtri dei messaggi.',
		2	=> '%d messaggi privati sono stati rimossi per i filtri dei messaggi',
	),

	'SAME_PASSWORD_ERROR'		=> 'La nuova password inserita è identica alla password attuale.',
	'SEARCH_YOUR_POSTS'			=> 'Mostra i tuoi argomenti',
	'SEND_PASSWORD'				=> 'Genera nuova password',
	'SENT_AT'					=> 'Inviato',	// Used before dates in private messages
	'SHOW_EMAIL'				=> 'Rendi visibile il tuo indirizzo email',
	'SIGNATURE_EXPLAIN'			=> 'Questo è un blocco di testo che può essere aggiunto in fondo ai tuoi messaggi. Il limite caratteri è di %d.',
	'SIGNATURE_PREVIEW'			=> 'Così apparirà la firma nei tuoi messaggi',
	'SIGNATURE_TOO_LONG'		=> 'La tua firma è troppo lunga.',
	'SELECT_CURRENT_TIME'		=> 'Seleziona orario corrente',
	'SELECT_TIMEZONE'			=> 'Seleziona fuso orario',
	'SORT'						=> 'Ordina',
	'SORT_COMMENT'				=> 'Commento file',
	'SORT_DOWNLOADS'			=> 'Download',
	'SORT_EXTENSION'			=> 'Estensione',
	'SORT_FILENAME'				=> 'Nome file',
	'SORT_POST_TIME'			=> 'Ora invio',
	'SORT_SIZE'					=> 'Grandezza file',

	'TIMEZONE'					=> 'Fuso orario',
	'TIMEZONE_DATE_SUGGESTION'	=> 'Suggerimento: %s',
	'TIMEZONE_INVALID'			=> 'Il fuso orario selezionato non è valido.',
	'TO'						=> 'A',
	'TO_MASS'					=> 'Destinatari',
	'TO_ADD'					=> 'Aggiungi destinatario',
	'TO_ADD_MASS'				=> 'Aggiungi destinatari',
	'TO_ADD_GROUPS'				=> 'Aggiungi gruppi',
	'TOO_MANY_RECIPIENTS'		=> 'Hai cercato di inviare un messaggio a troppi destinatari.',
	'TOO_MANY_REGISTERS'		=> 'Hai superato il numero massimo di tentativi di registrazione per questa sessione. Riprova più tardi.',

	'UCP'						=> 'Pannello di Controllo Utente',
	'UCP_ACTIVATE'				=> 'Attiva account',
	'UCP_ADMIN_ACTIVATE'		=> 'N.B. devi inserire un indirizzo email valido per l’attivazione del tuo account. Un amministratore valuterà la tua richiesta di registrazione e se approvato, riceverai una comunicazione all’indirizzo che hai specificato.',
	'UCP_ATTACHMENTS'			=> 'Gestione allegati',
	'UCP_AUTH_LINK'				=> 'Account esterni',
	'UCP_AUTH_LINK_ASK'			=> 'Al momento non hai account associati con questo servizio esterno. Clicca sul bottone in basso per collegare l’account della Board con un servizio esterno.',
	'UCP_AUTH_LINK_ID'			=> 'Identificativo univoco',
	'UCP_AUTH_LINK_LINK'		=> 'Collega',
	'UCP_AUTH_LINK_MANAGE'		=> 'Gestisci associazione account esterni',
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'Collegare l’account ad un servizio esterno non è una operazione supportata dal sistema di autenticazione della Board.',
	'UCP_AUTH_LINK_TITLE'		=> 'Gestisci le tue associazioni account esterni',
	'UCP_AUTH_LINK_UNLINK'		=> 'Scollega',
	'UCP_COPPA_BEFORE'			=> 'Prima del %s',
	'UCP_COPPA_ON_AFTER'		=> 'Dal %s in poi',
	'UCP_EMAIL_ACTIVATE'		=> 'N.B. devi inserire un indirizzo email valido per l’attivazione del tuo account. Riceverai un’email all’indirizzo che hai specificato, contenente un collegamento per l’attivazione dell’account.',
	'UCP_JABBER'				=> 'Indirizzo Jabber',
	'UCP_LOGIN_LINK'			=> 'Imposta un’associazione account esterna',

	'UCP_MAIN'					=> 'Panoramica',
	'UCP_MAIN_ATTACHMENTS'		=> 'Gestione allegati',
	'UCP_MAIN_BOOKMARKS'		=> 'Gestione segnalibri',
	'UCP_MAIN_DRAFTS'			=> 'Gestione bozze',
	'UCP_MAIN_FRONT'			=> 'Prima pagina',
	'UCP_MAIN_SUBSCRIBED'		=> 'Gestione sottoscrizioni',

	'UCP_NO_ATTACHMENTS'		=> 'Non hai allegati.',

	'UCP_NOTIFICATION_LIST'				=> 'Gestisci notifiche',
	'UCP_NOTIFICATION_LIST_EXPLAIN'		=> 'Qui puoi vedere tutte le vecchie notifiche.',
	'UCP_NOTIFICATION_OPTIONS'			=> 'Modifica opzioni di notifica',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'Qui puoi impostare il metodo di notifica che preferisci per la Board.',

	'UCP_PREFS'					=> 'Preferenze',
	'UCP_PREFS_PERSONAL'		=> 'Preferenze globali',
	'UCP_PREFS_POST'			=> 'Preferenze messaggi',
	'UCP_PREFS_VIEW'			=> 'Opzioni di visualizzazione',

	'UCP_PM'					=> 'Messaggi privati',
	'UCP_PM_COMPOSE'			=> 'Scrivi messaggio',
	'UCP_PM_DRAFTS'				=> 'Gestione bozze MP',
	'UCP_PM_OPTIONS'			=> 'Regole, cartelle e preferenze',
	'UCP_PM_UNREAD'				=> 'Messaggi non letti',
	'UCP_PM_VIEW'				=> 'Vedi messaggi',

	'UCP_PROFILE'				=> 'Profilo',
	'UCP_PROFILE_AVATAR'		=> 'Modifica avatar',
	'UCP_PROFILE_PROFILE_INFO'	=> 'Modifica profilo',
	'UCP_PROFILE_REG_DETAILS'	=> 'Modifica account',
	'UCP_PROFILE_SIGNATURE'		=> 'Modifica firma',
	'UCP_PROFILE_AUTOLOGIN_KEYS'	=> 'Gestisci chiavi di login “Ricordami”',

	'UCP_USERGROUPS'			=> 'Gruppi',
	'UCP_USERGROUPS_MEMBER'		=> 'Modifica iscrizioni',
	'UCP_USERGROUPS_MANAGE'		=> 'Gestione gruppi',

	'UCP_PASSWORD_RESET_DISABLED'	=> 'La funzione di ripristino della password è stata disabilitata. Se hai bisogno di aiuto per accedere al tuo account, contatta l’%sAmministratore della Board%s',
	'UCP_REGISTER_DISABLE'			=> 'La creazione di un nuovo account non è attualmente possibile.',
	'UCP_REMIND'					=> 'Invia password',
	'UCP_RESEND'					=> 'Invia email di attivazione',
	'UCP_WELCOME'					=> 'Benvenuto nel Pannello di Controllo Utente. Da qui puoi monitorare, modificare o aggiornare il tuo <em>Profilo</em>. Puoi gestire tutte le tue <em>Preferenze</em>, attivare o disattivare la sottoscrizione a forum e/o argomenti. Se consentito, tramite l’apposita funzione <em>Messaggi Privati</em>, puoi scambiare messaggi privati con altri utenti. Puoi anche gestire le tue iscrizioni ai <em>Gruppi</em> e, tramite l’opzione <em>Amici &amp; Ignorati</em>, mantenere i contatti con le persone che conosci. Lo Staff potrebbe rilasciare degli annunci a tutti gli utenti del forum, che verranno visualizzati in questa pagina.',
	'UCP_ZEBRA'						=> 'Amici &amp; Ignorati',
	'UCP_ZEBRA_FOES'				=> 'Gestione ignorati',
	'UCP_ZEBRA_FRIENDS'				=> 'Gestione amici',
	'UNDISCLOSED_RECIPIENT'			=> 'Beneficiari riservati',
	'UNKNOWN_FOLDER'				=> 'Cartella sconosciuta',
	'UNWATCH_MARKED'				=> 'Smetti di controllare selezionati',
	'UPLOAD_AVATAR_FILE'			=> 'Carica dal tuo computer',
	'UPLOAD_AVATAR_URL'				=> 'Carica da un URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'Inserisci l’indirizzo URL di dove risiede l’immagine e verrà copiata su questo sito.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'	=> 'Il nome utente deve essere lungo tra %1$s e %2$s, deve contenere solo caratteri alfanumerici.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'	=> 'Il nome utente deve essere lungo tra %1$s e %2$s, deve contenere caratteri alfanumerici, lo spazio o -+_[].',
	'USERNAME_ASCII_EXPLAIN'			=> 'Il nome utente deve essere lungo tra %1$s e %2$s, deve contenere solo caratteri ASCII, quindi niente simboli speciali.',
	'USERNAME_LETTER_NUM_EXPLAIN'		=> 'Il nome utente deve essere lungo tra %1$s e %2$s, deve contenere solo lettere o numeri.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'	=> 'Il nome utente deve essere lungo tra %1$s e %2$s, deve contenere lettere, numeri, lo spazio o -+_[].',
	'USERNAME_CHARS_ANY_EXPLAIN'		=> 'La lunghezza deve essere tra %1$s e %2$s.',
	'USERNAME_TAKEN_USERNAME'			=> 'Il nome utente inserito è già in uso, inserisci un’alternativa.',
	'USERNAME_DISALLOWED_USERNAME'		=> 'Il nome utente inserito è stato respinto o contiene una parola non ammessa. Scegli un altro nome.',
	'USER_NOT_FOUND_OR_INACTIVE'		=> 'I nomi utente specificati non sono stati trovati o appartengono a utenti non attivi.',

	'VIEW_AVATARS'				=> 'Visualizza gli avatar',
	'VIEW_EDIT'					=> 'Visualizza/Modifica',
	'VIEW_FLASH'				=> 'Visualizza animazioni Flash',
	'VIEW_IMAGES'				=> 'Visualizza immagini nei messaggi',
	'VIEW_NEXT_HISTORY'			=> 'MP seguente in cronologia',
	'VIEW_NEXT_PM'				=> 'MP seguente',
	'VIEW_PM'					=> 'Visualizza messaggio',
	'VIEW_PM_INFO'				=> 'Dettagli messaggio',
	'VIEW_PM_MESSAGES'			=> array(
		1	=> '%d messaggio',
		2	=> '%d messaggi',
	),
	'VIEW_PREVIOUS_HISTORY'		=> 'MP precedente in cronologia',
	'VIEW_PREVIOUS_PM'			=> 'MP precedente',
	'VIEW_PROFILE'				=> 'Visualizza profilo',
	'VIEW_SIGS'					=> 'Visualizza firme',
	'VIEW_SMILIES'				=> 'Visualizza emoticon come immagini',
	'VIEW_TOPICS_DAYS'			=> 'Visualizza argomenti dei giorni scorsi',
	'VIEW_TOPICS_DIR'			=> 'Visualizza ordinamento degli argomenti',
	'VIEW_TOPICS_KEY'			=> 'Visualizza argomenti ordinati per',
	'VIEW_POSTS_DAYS'			=> 'Visualizza messaggi dei giorni scorsi',
	'VIEW_POSTS_DIR'			=> 'Visualizza ordinamento dei messaggi',
	'VIEW_POSTS_KEY'			=> 'Visualizza messaggi ordinati per',

	'WATCHED_EXPLAIN'			=> 'La sottoscrizione permette di tenere sotto controllo un argomento o un intero forum, avvisandoti quando un nuovo messaggio viene inserito. Questa è la lista di forum ed argomenti per i quali hai attivato una sottoscrizione. Per rimuoverla, seleziona il forum o l’argomento e clicca <em>Smetti di controllare selezionati</em>.',
	'WATCHED_FORUMS'			=> 'Forum controllati',
	'WATCHED_TOPICS'			=> 'Argomenti controllati',
	'WRONG_ACTIVATION'			=> 'La chiave di attivazione fornita non coincide con nessuna del database.',

	'YOUR_DETAILS'				=> 'Le tue attività',
	'YOUR_FOES'					=> 'I tuoi ignorati',
	'YOUR_FOES_EXPLAIN'			=> 'Per rimuovere nomi utente, selezionali e clicca invia.',
	'YOUR_FRIENDS'				=> 'I tuoi amici',
	'YOUR_FRIENDS_EXPLAIN'		=> 'Per rimuovere nomi utente, selezionali e clicca invia.',
	'YOUR_WARNINGS'				=> 'Il tuo livello di richiami',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'Inserisci nella cartella',
		'MARK_AS_READ'		=> 'Segna come già letto',
		'MARK_AS_IMPORTANT'	=> 'Evidenzia messaggio',
		'DELETE_MESSAGE'	=> 'Cancella messaggio',
	),
	'PM_CHECK' => array(
		'SUBJECT'	=> 'Titolo',
		'SENDER'	=> 'Mittente',
		'MESSAGE'	=> 'Messaggio',
		'STATUS'	=> 'Stato del messaggio',
		'TO'		=> 'Inviato a',
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'è uguale a',
		'IS_NOT_LIKE'	=> 'è diverso da',
		'IS'			=> 'è',
		'IS_NOT'		=> 'non è',
		'BEGINS_WITH'	=> 'inizia con',
		'ENDS_WITH'		=> 'finisce con',
		'IS_FRIEND'		=> 'è amico',
		'IS_FOE'		=> 'è ignorato',
		'IS_USER'		=> 'è utente',
		'IS_GROUP'		=> 'è nel gruppo',
		'ANSWERED'		=> 'risposto',
		'FORWARDED'		=> 'inoltrato',
		'TO_GROUP'		=> 'al mio gruppo predefinito',
		'TO_ME'			=> 'a me',
	),

	'GROUPS_EXPLAIN'	=> 'I gruppi permettono agli amministratori di gestire al meglio gli utenti. All’inizio verrai inserito in un gruppo che sarà il tuo gruppo predefinito. Questo gruppo definisce come tu apparirai agli altri utenti, ad esempio la colorazione del tuo nome utente, l’avatar, il livello, ecc. Qualora gli amministratori lo concedano, potrai cambiare il tuo gruppo predefinito. Potresti essere inserito in altri gruppi o avere la possibilità di iscriverti. Alcuni gruppi potrebbero darti permessi aggiuntivi per vedere contenuti o aumentare le tue possibilità in altre sezioni del Forum.',
	'GROUP_LEADER'		=> 'Leader gruppo',
	'GROUP_MEMBER'		=> 'Iscrizioni',
	'GROUP_PENDING'		=> 'Iscrizione in attesa',
	'GROUP_NONMEMBER'	=> 'Non iscritti',
	'GROUP_DETAILS'		=> 'Dettagli gruppo',

	'NO_LEADER'		=> 'Nessun leader di gruppo',
	'NO_MEMBER'		=> 'Nessun iscritto al gruppo',
	'NO_PENDING'	=> 'Nessuna iscrizione in attesa',
	'NO_NONMEMBER'	=> 'Nessun gruppo non iscritto',
));
