<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @copyright (c) 2010 phpBB.it
* @copyright (c) 2014 phpBBItalia.net <http://www.phpbbitalia.net>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Traduzione Italiana <a href="http://www.phpbbitalia.net">phpBBItalia.net</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'it',

	// You can define different rules for the determination of plural forms here.
	// See http://wiki.phpbb.com/Plural_Rules for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 giorno',
	'1_MONTH'		=> '1 mese',
	'1_YEAR'		=> '1 anno',
	'2_WEEKS'		=> '2 settimane',
	'3_MONTHS'		=> '3 mesi',
	'6_MONTHS'		=> '6 mesi',
	'7_DAYS'		=> '7 giorni',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Il tuo account è già stato attivato.',
	'ACCOUNT_DEACTIVATED'			=> 'Il tuo account è stato disattivato e può essere riattivato solo da un amministratore.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Il tuo account non è ancora stato attivato.',
	'ACP'							=> 'Pannello di Controllo Amministratore',
	'ACP_SHORT'						=> 'PCA',
	'ACTIVE'						=> 'Attivo',
	'ACTIVE_ERROR'					=> 'Il nome utente inserito risulta ancora inattivo. Se riscontri problemi nell’attivazione dell’account contatta un amministratore.',
	'ADMINISTRATOR'					=> 'Amministratore',
	'ADMINISTRATORS'				=> 'Amministratori',
	'AGE'							=> 'Età',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'Errore AJAX',
	'AJAX_ERROR_TEXT'				=> 'Si è verificato un errore durante l’elaborazione della richiesta.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Richiesta utente interrotta',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'La tua richiesta è scaduta; riprova.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Si è verificato un errore con la richiesta e il server ha restituito una risposta non valida.',
	'ALLOWED'						=> 'Permesso',
	'ALL_FILES'						=> 'Tutti i file',
	'ALL_FORUMS'					=> 'Tutti i forum',
	'ALL_MESSAGES'					=> 'Tutti i messaggi privati',
	'ALL_POSTS'						=> 'Tutti i messaggi',
	'ALL_TIMES'						=> 'Tutti gli orari sono <abbr title="%2$s">%1$s</abbr>',
	'ALL_TOPICS'					=> 'Tutti gli argomenti',
	'AND'							=> 'E',
	'ARE_WATCHING_FORUM'			=> 'Hai scelto di ricevere aggiornamenti per questo forum.',
	'ARE_WATCHING_TOPIC'			=> 'Hai scelto di ricevere aggiornamenti per questo argomento.',
	'ASCENDING'						=> 'Crescente',
	'ATTACHMENTS'					=> 'Allegati',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Il file immagine che vuoi allegare non è valido.',
	'AUTHOR'						=> 'Autore',
	'AUTH_NO_PROFILE_CREATED'		=> 'La creazione del profilo utente è fallita.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Voce database non valida.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Tipo di servizio non valido fornito al gestore del servizio OAuth.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Servizio OAuth non creato',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Token di OAuth non memorizzato.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth token correttamente conservato.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Il contenuto è stato respinto in quanto il file caricato è stato identificato come un possibile vettore di attacco.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Questo file non può essere visualizzato perché l’estensione <strong>%s</strong> non è permessa.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'L’avatar non può essere caricato, il file potrebbe non essere valido o corrotto.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Il file dell’avatar inviato è vuoto.',
	'AVATAR_INVALID_FILENAME'		=> '%s è un nome file non valido.',
	'AVATAR_NOT_UPLOADED'			=> 'L’avatar non può essere caricato.',
	'AVATAR_NO_SIZE'				=> 'Non è possibile determinare larghezza o altezza dell’avatar collegato. Inserisci i valori manualmente.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Il file è stato caricato solo parzialmente.',
	'AVATAR_PHP_SIZE_NA'			=> 'Il file avatar è troppo grande.<br />Non è possibile determinare la grandezza massima permessa definita da PHP in php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Il file avatar è troppo grande. la dimensione massima permessa è %1$d %2$s.<br />Questo valore è impostato nel file di sistema php.ini e non può essere modificato.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Il file avatar specificato non può essere caricato a causa del time out della richiesta.',
	'AVATAR_URL_INVALID'			=> 'L’indirizzo specificato non è valido.',
	'AVATAR_URL_NOT_FOUND'			=> 'Il file specificato non può essere trovato.',
	'AVATAR_WRONG_FILESIZE'			=> 'La dimensione file dell’avatar deve essere compresa tra 0 e %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'L’avatar inviato è largo %5$s pixel e alto %6$s pixel. Gli avatar devono avere una larghezza minima di %1$s pixel e un’altezza minima di %2$s pixel, mentre non possono superare %3$s pixel di larghezza e %4$s pixel di altezza.',

	'BACK_TO_TOP'			=> 'Top',
	'BACK_TO_PREV'			=> 'Torna alla pagina precedente',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Questo ban è riferito al tuo indirizzo email.',
	'BAN_TRIGGERED_BY_IP'	=> 'Questo ban è riferito al tuo indirizzo IP.',
	'BAN_TRIGGERED_BY_USER'	=> 'Questo ban è riferito al tuo nome utente.',
	'BBCODE_GUIDE'			=> 'Guida al BBCode',
	'BCC'					=> 'CCN',
	'BIRTHDAYS'				=> 'Compleanni',
	'BOARD_BAN_PERM'		=> 'Sei stato <strong>permanentemente</strong> bannato da questa Board.<br /><br />Contatta un %2$samministratore%3$s per maggiori informazioni.',
	'BOARD_BAN_REASON'		=> 'Motivazione del ban: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Sei stato bannato fino al <strong>%1$s</strong>.<br /><br />Contatta un %2$samministratore%3$s per maggiori informazioni.',
	'BOARD_DISABLE'			=> 'Spiacente, in questo momento la Board è irraggiungibile.',
	'BOARD_DISABLED'		=> 'La Board è momentaneamente disattivata.',
	'BOARD_UNAVAILABLE'		=> 'Spiacente, la Board è momentaneamente irraggiungibile. Riprova tra qualche minuto.',
	'BROWSING_FORUM'		=> 'Visitano il forum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Visitano il forum: %2$s e %1$d ospite',
		2	=> 'Visitano il forum: %2$s e %1$d ospiti',
	),
	'BUTTON_EDIT'			=> 'Modifica',
	'BUTTON_FORUM_LOCKED'	=> 'Bloccato',
	'BUTTON_NEW_TOPIC'		=> 'Nuovo argomento',
	'BUTTON_PM'				=> 'PM',
	'BUTTON_PM_FORWARD'		=> 'Inoltra',
	'BUTTON_PM_NEW'			=> 'Nuovo PM',
	'BUTTON_PM_REPLY'		=> 'Invia risposta',
	'BUTTON_PM_REPLY_ALL'	=> 'Rispondi a tutti',
	'BUTTON_POST_REPLY'		=> 'Rispondi',
	'BUTTON_QUOTE'			=> 'Cita',
	'BUTTON_TOPIC_LOCKED'	=> 'Bloccato',
	'BYTES'					=> 'Byte',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Annulla',
	'CHANGE'				=> 'Modifica',
	'CHANGE_FONT_SIZE'		=> 'Modifica la dimensione del carattere',
	'CHANGING_PREFERENCES'	=> 'Modifica le preferenze della Board',
	'CHANGING_PROFILE'		=> 'Modifica le impostazioni del profilo',
	'CHARACTERS'			=> array(
		1	=> '%d carattere',
		2	=> '%d caratteri',
	),
	'COLLAPSE_VIEW'			=> 'Contrai vista',
	'CLOSE_WINDOW'			=> 'Chiudi finestra',
	'COLOUR_SWATCH'			=> 'Colore campione',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Conferma',
	'CONFIRM_CODE'			=> 'Codice di conferma',
	'CONFIRM_CODE_EXPLAIN'	=> 'Inserisci il codice esattamente come lo vedi nell’immagine. Non c’è differenza tra maiuscole e minuscole. Lo zero non esiste.',
	'CONFIRM_CODE_WRONG'	=> 'Il codice di conferma inserito è errato.',
	'CONFIRM_OPERATION'		=> 'Sei sicuro di voler effettuare questa operazione?',
	'CONFIRM_AVATAR_DELETE' => 'Sei sicuro di voler cancellare questo avatar?',
	'CONGRATULATIONS'		=> 'Tanti auguri a',
	'CONNECTION_FAILED'		=> 'Connessione fallita.',
	'CONNECTION_SUCCESS'	=> 'Connessione riuscita!',
	'CONTACT'				=> 'Contatta',
	'CONTACT_USER'			=> 'Contatta %s',
	'CONTACT_US'			=> 'Contattaci',
	'COOKIES_DELETED'		=> 'Tutti i cookie sono stati cancellati correttamente.',
	'CURRENT_TIME'			=> 'Oggi è %s',

	'DAY'					=> 'Giorno',
	'DAYS'					=> 'giorni',
	'DELETE'				=> 'Cancella',
	'DELETE_ALL'			=> 'Cancella tutto',
	'DELETE_COOKIES'		=> 'Cancella cookie',
	'DELETE_MARKED'			=> 'Cancella selezionati',
	'DELETE_POST'			=> 'Cancella messaggio',
	'DELIMITER'				=> 'Delimitatore',
	'DESCENDING'			=> 'Decrescente',
	'DISABLED'				=> 'Disabilitato',
	'DISPLAY'				=> 'Visualizza',
	'DISPLAY_GUESTS'		=> 'Visualizza ospiti',
	'DISPLAY_MESSAGES'		=> 'Visualizza ultimi messaggi',
	'DISPLAY_POSTS'			=> 'Visualizza ultimi messaggi',
	'DISPLAY_TOPICS'		=> 'Visualizza ultimi argomenti',
	'DOWNLOADED'			=> 'Scaricato',
	'DOWNLOADING_FILE'		=> 'Download file in corso',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Mai scaricato',
		1	=> 'Scaricato %d volta',
		2	=> 'Scaricato %d volte',
	),

	'EDIT_POST'							=> 'Modifica messaggio',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'Email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Indirizzo email',
	'EMAIL_INVALID_EMAIL'				=> 'L’indirizzo email che hai inserito non è valido.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Si è verificato un errore durante l’invio dell’email alla <strong>riga %1$s</strong>. Messaggio: %2$s.',
	'EMPTY_SUBJECT'						=> 'Devi specificare un oggetto per il nuovo argomento.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Devi specificare un oggetto per il nuovo messaggio.',
	'ENABLED'							=> 'Abilitato',
	'ENCLOSURE'							=> 'Incluso',
	'ENTER_USERNAME'					=> 'Inserisci nome utente',
	'ERR_CHANGING_DIRECTORY'			=> 'Impossibile cambiare cartella.',
	'ERR_CONNECTING_SERVER'				=> 'Errore durante la connessione al server.',
	'ERR_JAB_AUTH'						=> 'Autorizzazione negata sul server Jabber.',
	'ERR_JAB_CONNECT'					=> 'Impossibile connettersi al server Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Il nome utente o la password non sono corretti.',
	'ERR_UNWATCHING'					=> 'Si è verificato un errore durante l’annullamento della sottoscrizione.',
	'ERR_WATCHING'						=> 'Si è verificato un errore durante la sottoscrizione.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Il percorso a phpBB specificato sembra non essere valido.',
	'ERROR'								=> 'Errore',
	'EXPAND_VIEW'						=> 'Espandi visuale',
	'EXTENSION'							=> 'Estensione',
	'EXTENSION_DISABLED'				=> 'L’estensione <strong>%s</strong> non è abilitata.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'L’estensione <strong>%s</strong> è stata disattivata e non può essere visualizzata.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'L’estensione <strong>%s</strong> non esiste.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'FAQ (Domande Frequenti)',
	'FILENAME'				=> 'Nome file',
	'FILESIZE'				=> 'Dimensione file',
	'FILEDATE'				=> 'Data del file',
	'FILE_COMMENT'			=> 'Commento file',
	'FILE_CONTENT_ERR'		=> 'Non è stato possibile leggere il contenuto del file: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Fallita la decodifica del file json: %s',
	'FILE_NOT_FOUND'		=> 'Il file cercato non può essere trovato: %s',
	'FIND_USERNAME'			=> 'Trova utente',
	'FOLDER'				=> 'Cartella',
	'FORGOT_PASS'			=> 'Ho dimenticato la password',
	'FORM_INVALID'			=> 'Il form inviato non è valido. Prova a inviarlo di nuovo.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forum',
	'FORUMS_MARKED'			=> 'I forum sono stati segnati come già letti.',
	'FORUM_CAT'				=> 'Categoria forum',
	'FORUM_INDEX'			=> 'Indice',
	'FORUM_LINK'			=> 'Forum link',
	'FORUM_LOCATION'		=> 'Posizione forum',
	'FORUM_LOCKED'			=> 'Forum bloccato',
	'FORUM_RULES'			=> 'Regole del forum',
	'FORUM_RULES_LINK'		=> 'Clicca per leggere le regole del forum',
	'FROM'					=> 'da',
	'FSOCK_DISABLED'		=> 'L’operazione non può essere terminata perché la funzione <var>fsockopen</var> è stata disabilitata o il server interrogato non può essere trovato.',
	'FSOCK_TIMEOUT'			=> 'Si è verificato un timeout durante la lettura dal flusso di rete.',

	'FTP_FSOCK_HOST'				=> 'Host FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Server FTP utilizzato per la connessione del tuo sito.',
	'FTP_FSOCK_PASSWORD'			=> 'Password FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Password per il tuo nome utente FTP.',
	'FTP_FSOCK_PORT'				=> 'Porta FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Porta utilizzata per connetterti al server FTP.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Percorso a phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Percorso alla cartella principale di phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Timeout FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Tempo, in secondi, in cui il sistema attende una risposta da parte del server.',
	'FTP_FSOCK_USERNAME'			=> 'Nome utente FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nome utente utilizzato per connetterti al server.',

	'FTP_HOST'					=> 'Host FTP',
	'FTP_HOST_EXPLAIN'			=> 'Server FTP utilizzato per la connessione del tuo sito.',
	'FTP_PASSWORD'				=> 'Password FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Password per il tuo nome utente FTP.',
	'FTP_PORT'					=> 'Porta FTP',
	'FTP_PORT_EXPLAIN'			=> 'Porta utilizzata per connetterti al server.',
	'FTP_ROOT_PATH'				=> 'Percorso a phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Percorso alla cartella principale di phpBB.',
	'FTP_TIMEOUT'				=> 'Timeout FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Tempo, in secondi, in cui il sistema attende una risposta da parte del server.',
	'FTP_USERNAME'				=> 'Nome utente FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nome utente utilizzato per connetterti al server.',

	'GENERAL_ERROR'				=> 'Errore Generale',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Vai',
	'GOOGLEPLUS'				=> 'Google+',
	'GOTO_FIRST_POST'			=> 'Vai al primo messaggio',
	'GOTO_LAST_POST'			=> 'Vai all’ultimo messaggio',
	'GOTO_PAGE'					=> 'Vai alla pagina',
	'GROUP'						=> 'Gruppo',
	'GROUPS'					=> 'Gruppi',
	'GROUP_ERR_TYPE'			=> 'Il tipo di gruppo specificato non è appropriato.',
	'GROUP_ERR_USERNAME'		=> 'Non hai specificato un nome per il gruppo.',
	'GROUP_ERR_USER_LONG'		=> 'Il nome gruppo non deve superare i 60 caratteri. Il nome gruppo specificato è troppo lungo.',
	'GUEST'						=> 'Ospite',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'C’è %d ospite connesso',
		2	=> 'Ci sono %d ospiti connessi',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d ospite',
		2	=> '%d ospiti',
	),
	'G_ADMINISTRATORS'			=> 'Amministratori',
	'G_BOTS'					=> 'Bot',
	'G_GUESTS'					=> 'Ospiti',
	'G_REGISTERED'				=> 'Utenti registrati',
	'G_REGISTERED_COPPA'		=> 'Utenti COPPA registrati',
	'G_GLOBAL_MODERATORS'		=> 'Moderatori globali',
	'G_NEWLY_REGISTERED'		=> 'Nuovi utenti registrati',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d utente nascosto',
		2	=> '%d utenti nascosti',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d nascosto',
		2	=> '%d nascosti',
	),
	'HIDE_GUESTS'					=> 'Nascondi ospiti',
	'HIDE_ME'						=> 'Nascondi il mio stato per questa sessione',
	'HOURS'							=> 'Ore',

	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Se',
	'IMAGE'						=> 'Immagine',
	'IMAGE_FILETYPE_INVALID'	=> 'Il file immagine con estensione %d per il mimetype %s, non è supportato.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Errore nel formato immagine: dovrebbe avere estensione %1$s ma ha estensione %2$s.',
	'IN'						=> 'in',
	'INACTIVE'					=> 'Inattivo',
	'INDEX'						=> 'Indice',
	'INFORMATION'				=> 'Informazione',
	'INSECURE_REDIRECT'			=> 'Effettuato un tentativo di reindirizzamento verso un URL potenzialmente insicuro.',
	'INTERESTS'					=> 'Interessi',
	'INVALID_DIGEST_CHALLENGE'	=> 'Dato inserito non valido.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> potrebbe essere un indirizzo email non valido?',
	'INVALID_PLURAL_RULE'		=> 'La regola plurale scelto non è valida. I valori validi sono numeri interi compresi tra 0 e 15.',

	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Il tuo IP %1$s è stato bloccato perché incluso nella blacklist. Per maggiori dettagli <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Iscritto il',
	'JUMP_PAGE'				=> 'Inserisci il numero della pagina alla quale vuoi andare.',
	'JUMP_TO'				=> 'Vai a',
	'JUMP_TO_PAGE'			=> 'Vai alla pagina',
	'JUMP_TO_PAGE_CLICK'	=> 'Clicca per andare alla pagina…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Ultimo messaggio',
	'LAST_UPDATED'						=> 'Ultima attività',
	'LAST_VISIT'						=> 'Ultima visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Estensione LDAP non disponibile.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Impossibile connettersi al server LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Si è verificato un errore durante la ricerca della directory LDAP.',
	'LEGEND'							=> 'Legenda',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Le ricerca in tempo reale non sono ammesse.',
	'LOADING'							=> 'Caricamento',
	'LOCATION'							=> 'Località',
	'LOCK_POST'							=> 'Blocca messaggio',
	'LOCK_POST_EXPLAIN'					=> 'Non permette modifiche',
	'LOCK_TOPIC'						=> 'Blocca argomento',
	'LOGIN'								=> 'Login',
	'LOGIN_CHECK_PM'					=> 'Collegati per controllare i messaggi privati.',
	'LOGIN_CONFIRMATION'				=> 'Conferma login',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Dopo un numero massimo di tentativi di accesso falliti verrà richiesto l’inserimento di un codice di conferma. Questo serve a prevenire accessi non autorizzati. Il codice è visualizzato nell’immagine sottostante. Se l’immagine non compare o se hai problemi di visualizzazione, contatta un %samministratore%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Hai superato il numero massimo di tentativi di accesso. In aggiunta al tuo nome utente e password ora devi anche risolvere il CAPTCHA qui di seguito.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Non sei stato riconosciuto da Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'È stato richiesto un servizio di OAuth inesistente.',
	'LOGIN_ERROR_PASSWORD'				=> 'La password inserita non è corretta, fai un altro tentativo. Se il problema persiste contatta un %sAmministratore%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Non è stato possibile convertire la tua password al momento dell’aggiornamento del software di questa Board. %sRichiedi una nuova password%s. Se il problema persiste contatta un %samministratore%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Il nome utente inserito non è corretto, fai un altro tentativo. Se il problema persiste contatta un %sAmministratore%s.',
	'LOGIN_FORUM'						=> 'Per leggere o inviare messaggi su questo forum devi inserire la password.',
	'LOGIN_INFO'						=> 'Per eseguire il login devi essere registrato. La registrazione richiede solo pochi secondi e garantisce l’accesso alle funzioni avanzate. L’amministratore può anche dare permessi speciali agli utenti. Prima di eseguire il login assicurati di aver letto i termini d’uso e le varie regole.',
	'LOGIN_VIEWFORUM'					=> 'Per leggere questo forum devi essere registrato ed aver effettuato il login.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Per modificare i messaggi di questo forum devi essere registrato ed aver effettuato il login.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Per visualizzare la lista utenti in linea devi essere registrato e loggato.',
	'LOGIN_REQUIRED'					=> 'Devi effettuare il login per eseguire questa azione.',
	'LOGOUT'							=> 'Logout',
	'LOGOUT_USER'						=> 'Logout [ %s ]',
	'LOG_ME_IN'							=> 'Ricordami',

	'MAIN'					=> 'Principale',
	'MARK'					=> 'Seleziona',
	'MARK_ALL'				=> 'Seleziona tutto',
	'MARK_ALL_READ'			=> 'Segna tutti come già letti',
	'MARK_FORUMS_READ'		=> 'Segna i forum come già letti',
	'MARK_READ'				=> 'Segna come già letti',
	'MARK_SUBFORUMS_READ'	=> 'Segna i subforum come già letti',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Pannello di Controllo Moderatore',
	'MCP_SHORT'				=> 'PCM',
	'MEMBERLIST'			=> 'Iscritti',
	'MEMBERLIST_EXPLAIN'	=> 'Lista utenti registrati',
	'MERGE'					=> 'Unisci',
	'MERGE_POSTS'			=> 'Sposta messaggi',
	'MERGE_TOPIC'			=> 'Unisci argomento',
	'MESSAGE'				=> 'Messaggio',
	'MESSAGES'				=> 'Messaggi',
	'MESSAGES_COUNT'		=> array(
		1	=> '%d messaggio',
		2	=> '%d messaggi',
	),
	'MESSAGE_BODY'			=> 'Corpo del messaggio',
	'MINUTES'				=> 'Minuti',
	'MODERATE'				=> 'Modera',
	'MODERATOR'				=> 'Moderatore',
	'MODERATORS'			=> 'Moderatori',
	'MODULE_NOT_ACCESS'		=> 'Modulo non accessibile',
	'MODULE_NOT_FIND'		=> 'Impossibile trovare il modulo %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Il modulo file %s non contiene una corretta classe [%s]',
	'MONTH'					=> 'Mese',
	'MOVE'					=> 'Sposta',

	'NA'						=> 'Non disponibile',
	'NEWEST_USER'				=> 'Ultimo iscritto <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nuovo messaggio',
	'NEW_MESSAGES'				=> 'Nuovi messaggi',
	'NEW_POST'					=> 'Nuovo messaggio',	// Not used anymore
	'NEW_POSTS'					=> 'Nuovi messaggi',	// Not used anymore
	'NEXT'						=> 'Prossimo',	// Used in pagination
	'NEXT_STEP'					=> 'Avanti',
	'NEVER'						=> 'Mai',

	'NO'						=> 'No',
	'NO_NOTIFICATIONS'			=> 'Non hai nessuna notifica',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Non hai il permesso di gestire questo gruppo.',
	'NOT_AUTHORISED'			=> 'Non hai il permesso di accedere a quest’area.',
	'NOT_WATCHING_FORUM'		=> 'La tua sottoscrizione a questo forum è terminata.',
	'NOT_WATCHING_TOPIC'		=> 'La tua sottoscrizione a questo argomento è terminata.',
	'NOTIFICATIONS'				=> 'Notifiche',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Risposta</strong> di %1$s all’argomento inserito nei segnalibri:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Richiesta gruppo</strong> di %1$s per aderire al gruppo %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Richiesta gruppo approvata</strong> per aderire al gruppo %1$s.',
	'NOTIFICATION_PM'					=> '<strong>Messaggio Privato</strong> da %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Risposta</strong> di %1$s all’argomento:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Messaggio approvato</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Messaggio disapprovato</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Approvazione messaggio</strong> richiesta da %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Citazione</strong> di %1$s in:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>Ragione:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Messaggio Privato segnalato</strong> da %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Messaggio segnalato</strong> da %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Segnalazione chiusa</strong> da %1$s per:',
	'NOTIFICATION_TOPIC'				=> '<strong>Nuovo argomento</strong> di %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Argomento approvato</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Argomento disapprovato</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Approvazione argomento</strong> richiesta da %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Il tipo di notifica "%s" manca dal file system.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Richiesta di attivazione</strong> per l’utente disattivato o per il nuovo utente registrato: “%1$s”',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'altri',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d altri',
	),
	'NOTIFY_ADMIN'				=> 'Per favore, invia notifica ad un amministratore.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Per favore, invia notifica ad un amministratore: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Non hai il permesso di accedere a questo file.',
	'NO_ACTION'					=> 'Nessuna azione specificata.',
	'NO_ADMINISTRATORS'			=> 'Non ci sono amministratori.',
	'NO_AUTH_ADMIN'				=> 'Non hai i permessi di amministratore, quindi non puoi accedere al pannello di controllo amministratore.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Non puoi autenticarti come altro utente.',
	'NO_AUTH_OPERATION'			=> 'Non hai i permessi necessari per completare questa operazione.',
	'NO_AVATARS'				=> 'Nessun avatar attualmente disponibile',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Impossibile connettersi all’host SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Nessun compleanno oggi',
	'NO_EMAIL_MESSAGE'			=> 'Il contenuto dell’email è vuoto',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Impossibile ottenere il codice di risposta del server mail.',
	'NO_EMAIL_SUBJECT'			=> 'Non è stato specificato un oggetto per l’email.',
	'NO_FORUM'					=> 'Il forum che hai selezionato non esiste.',
	'NO_FORUMS'					=> 'Non sono presenti forum.',
	'NO_GROUP'					=> 'Il gruppo richiesto non esiste.',
	'NO_GROUP_MEMBERS'			=> 'Questo gruppo non ha ancora iscritti.',
	'NO_IPS_DEFINED'			=> 'Nessun indirizzo IP o hostname definito',
	'NO_MEMBERS'				=> 'Nessun iscritto corrisponde a questi criteri di ricerca.',
	'NO_MESSAGES'				=> 'Nessun messaggio',
	'NO_MODE'					=> 'Nessuna modalità specificata.',
	'NO_MODERATORS'				=> 'Non ci sono moderatori.',
	'NO_NEW_MESSAGES'			=> 'Nessun nuovo messaggio',
	'NO_NEW_POSTS'				=> 'Nessun nuovo messaggio',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Nessuno',
	'NO_POSTS'					=> 'Nessun messaggio',
	'NO_POSTS_TIME_FRAME'		=> 'Nessun messaggio in questo argomento nel periodo impostato.',
	'NO_FEED_ENABLED'			=> 'I Feed non sono disponibili in questa Board.',
	'NO_FEED'					=> 'Il Feed richiesto non è disponibile.',
	'NO_STYLE_DATA'				=> 'Impossibile recuperare lo stile selezionato',
	'NO_SUBJECT'				=> 'Nessun oggetto specificato',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'La ricerca preimpostata non esiste.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Metodo di autenticazione non supportato.',
	'NO_TOPIC'					=> 'L’argomento richiesto non esiste.',
	'NO_TOPIC_FORUM'			=> 'L’argomento o il forum non esistono più.',
	'NO_TOPICS'					=> 'Non ci sono argomenti o messaggi in questo forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Nessun argomento in questo forum nel periodo impostato.',
	'NO_UNREAD_POSTS'			=> 'Nessun messaggio da leggere',
	'NO_UPLOAD_FORM_FOUND'		=> 'Caricamento iniziato, ma non è stata trovata alcuna forma valida di caricamento del file.',
	'NO_USER'					=> 'L’utente richiesto non esiste.',
	'NO_USERS'					=> 'Gli utenti richiesti non esistono.',
	'NO_USER_SPECIFIED'			=> 'Nessun nome utente specificato.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d allegato',
		2	=> '%d allegati',
	),
	'NUM_POSTS_IN_QUEUE' => array(
		0 => 'Nessun messaggio in coda approvazione',	// 0
		1 => '1 messaggio in coda approvazione',		// 1
		2 => '%d messaggi in coda approvazione',		// 2+
	),

	'OCCUPATION'				=> 'Occupazione',
	'OFFLINE'					=> 'Non connesso',
	'ONLINE'					=> 'Connesso',
	'ONLINE_BUDDIES'			=> 'Amici connessi',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'In totale c’è <strong>%1$d</strong> utente connesso :: %2$s e %3$s',
		2	=> 'In totale ci sono <strong>%1$d</strong> utenti connessi :: %2$s e %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'In totale c’è <strong>%1$d</strong> utente connesso :: %2$s, %3$s e %4$s',
		2	=> 'In totale ci sono <strong>%1$d</strong> utenti connessi :: %2$s, %3$s e %4$s',
	),
	'OPTIONS'					=> 'Opzioni',

	'PAGE_OF'				=> 'Pagina <strong>%1$d</strong> di <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Pagina %s',
	'PASSWORD'				=> 'Password',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d pixel',
		2	=> '%d pixel',
	),
	'PLAY_QUICKTIME_FILE'		=> 'Riproduci file Quicktime',
	'PLEASE_WAIT'				=> 'Attendere prego.',
	'PM'						=> 'MP',
	'PM_REPORTED'				=> 'Clicca per visualizzare la segnalazione',
	'POSTING_MESSAGE'			=> 'Sta inviando un messaggio in %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Sta scrivendo un messaggio privato',
	'POST'						=> 'Messaggio',
	'POST_ANNOUNCEMENT'			=> 'Annuncio',
	'POST_STICKY'				=> 'Importante',
	'POSTED'					=> 'Inviato',
	'POSTED_IN_FORUM'			=> 'in',
	'POSTED_ON_DATE'			=> 'il',
	'POSTS'						=> 'Messaggi',
	'POSTS_UNAPPROVED'			=> 'Uno o più messaggi in questo argomento non sono stati approvati.',
	'POSTS_UNAPPROVED_FORUM'	=> 'Uno o più messaggi in questo forum non sono stati approvati.',
	'POST_BY_AUTHOR'			=> 'da',
	'POST_BY_FOE'				=> 'Questo messaggio è stato scritto da <strong>%1$s</strong>, che è inserito nella tua lista ignorati.',
	'POST_DISPLAY'				=> '%1$sVisualizza questo messaggio%2$s.',
	'POST_DAY'					=> '%.2f messaggi al giorno',
	'POST_DELETED_ACTION'		=> 'Messaggio eliminato:',
	'POST_DELETED'				=> 'Questo messaggio è stato eliminato.',
	'POST_DELETED_BY'			=> '<strong>%2$s</strong> cancellato il messaggio di <strong>%1$s</strong> su %3$s.',
	'POST_DELETED_BY_REASON'	=> '<strong>%2$s</strong> cancellato il messaggio di <strong>%1$s</strong> su %3$s per la seguente ragione: %4$s',
	'POST_DETAILS'				=> 'Dettagli messaggio',
	'POST_NEW_TOPIC'			=> 'Apri un nuovo argomento',
	'POST_PCT'					=> '%.2f%% del totale messaggi',
	'POST_PCT_ACTIVE'			=> '%.2f%% dei messaggi dell’utente',
	'POST_PCT_ACTIVE_OWN'		=> '%.2f%% dei tuoi messaggi',
	'POST_REPLY'				=> 'Rispondi al messaggio',
	'POST_REPORTED'				=> 'Clicca per vedere la segnalazione',
	'POST_SUBJECT'				=> 'Oggetto del messaggio',
	'POST_TIME'					=> 'Ora di invio',
	'POST_TOPIC'				=> 'Scrivi un nuovo argomento',
	'POST_UNAPPROVED_ACTION'	=> 'Messaggio in attesa di approvazione:',
	'POST_UNAPPROVED'			=> 'Questo messaggio non è stato approvato.',
	'POWERED_BY'				=> 'Powered by %s',
	'PREVIEW'					=> 'Anteprima',
	'PREVIOUS'					=> 'Precedente',	// Used in pagination
	'PREVIOUS_STEP'				=> 'Indietro',
	'PRIVACY'					=> 'Trattamento dei dati personali',
	'PRIVATE_MESSAGE'			=> 'Messaggio privato',
	'PRIVATE_MESSAGES'			=> 'Messaggi privati',
	'PRIVATE_MESSAGING'			=> 'Messaggistica privata',
	'PROFILE'					=> 'Pannello di Controllo Utente',

	'QUICK_LINKS'				=> 'Collegamenti Rapidi',

	'RANK'						=> 'Livello',
	'READING_FORUM'				=> 'Sta leggendo un argomento in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Sta leggendo un annuncio globale',
	'READING_LINK'				=> 'Sta seguendo un collegamento del forum %s',
	'READING_TOPIC'				=> 'Sta leggendo un argomento in %s',
	'READ_PROFILE'				=> 'Profilo',
	'REASON'					=> 'Motivazione',
	'RECORD_ONLINE_USERS'		=> 'Record di utenti connessi: <strong>%1$s</strong> registrato il %2$s',
	'REDIRECT'					=> 'Reindirizzamento',
	'REDIRECTS'					=> 'Reindirizzamenti totali',
	'REGISTER'					=> 'Iscriviti',
	'REGISTERED_USERS'			=> 'Iscritti connessi:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'C’è %1$d utente iscritto e %2$s connesso',
		2	=> 'Ci sono %1$d utenti iscritti e %2$s connessi',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d registrato',
		2	=> '%d registrati',
	),
	'REMOVE'					=> 'Rimuovi',
	'REMOVE_INSTALL'			=> 'Cancella, sposta o rinomina la cartella di installazione prima di continuare. Se questa cartella è ancora presente sarà solo possibile accedere all’amministrazione.',
	'REPLIES'					=> 'Risposte',
	'REPLY_WITH_QUOTE'			=> 'Rispondi citando',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Sta rispondendo all’annuncio globale',
	'REPLYING_MESSAGE'			=> 'Sta rispondendo al messaggio in %s',
	'REPORT_BY'					=> 'Segnalato da',
	'REPORT_POST'				=> 'Segnala il messaggio',
	'REPORTING_POST'			=> 'Sta facendo la segnalazione di un messaggio',
	'RESEND_ACTIVATION'			=> 'Rispedisci l’email di attivazione',
	'RESET'						=> 'Ripristina',
	'RESTORE_PERMISSIONS'		=> 'Ripristina permessi',
	'RETURN_INDEX'				=> '%sTorna all’Indice%s',
	'RETURN_FORUM'				=> '%sTorna all’ultimo forum visitato%s',
	'RETURN_PAGE'				=> '%sTorna alla pagina precedente%s',
	'RETURN_TOPIC'				=> '%sTorna all’ultimo argomento letto%s',
	'RETURN_TO'					=> 'Torna a “%s”',
	'RETURN_TO_INDEX'			=> 'Torna all’Indice della Board',

	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'News',
	'FEED_TOPICS_ACTIVE'		=> 'Argomenti attivi',
	'FEED_TOPICS_NEW'			=> 'Nuovi argomenti',
	'RULES_ATTACH_CAN'			=> '<strong>Puoi</strong> inviare allegati',
	'RULES_ATTACH_CANNOT'		=> '<strong>Non puoi</strong> inviare allegati',
	'RULES_DELETE_CAN'			=> '<strong>Puoi</strong> cancellare i tuoi messaggi',
	'RULES_DELETE_CANNOT'		=> '<strong>Non puoi</strong> cancellare i tuoi messaggi',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Puoi</strong> scaricare gli allegati',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Non puoi</strong> scaricare gli allegati',
	'RULES_EDIT_CAN'			=> '<strong>Puoi</strong> modificare i tuoi messaggi',
	'RULES_EDIT_CANNOT'			=> '<strong>Non puoi</strong> modificare i tuoi messaggi',
	'RULES_LOCK_CAN'			=> '<strong>Puoi</strong> bloccare i tuoi argomenti',
	'RULES_LOCK_CANNOT'			=> '<strong>Non puoi</strong> bloccare i tuoi argomenti',
	'RULES_POST_CAN'			=> '<strong>Puoi</strong> aprire nuovi argomenti',
	'RULES_POST_CANNOT'			=> '<strong>Non puoi</strong> aprire nuovi argomenti',
	'RULES_REPLY_CAN'			=> '<strong>Puoi</strong> rispondere negli argomenti',
	'RULES_REPLY_CANNOT'		=> '<strong>Non puoi</strong> rispondere negli argomenti',
	'RULES_VOTE_CAN'			=> '<strong>Puoi</strong> partecipare ai sondaggi',
	'RULES_VOTE_CANNOT'			=> '<strong>Non puoi</strong> partecipare ai sondaggi',

	'SEARCH'					=> 'Cerca',
	'SEARCH_MINI'				=> 'Cerca...',
	'SEARCH_ADV'				=> 'Ricerca avanzata',
	'SEARCH_ADV_EXPLAIN'		=> 'Visualizza le opzioni di ricerca avanzata',
	'SEARCH_KEYWORDS'			=> 'Ricerca per termini',
	'SEARCHING_FORUMS'			=> 'Sta cercando nel forum',
	'SEARCH_ACTIVE_TOPICS'		=> 'Argomenti attivi',
	'SEARCH_FOR'				=> 'Cerca per',
	'SEARCH_FORUM'				=> 'Cerca qui...',
	'SEARCH_NEW'				=> 'Messaggi recenti',
	'SEARCH_POSTS_BY'			=> 'Cerca i messaggi di',
	'SEARCH_SELF'				=> 'I tuoi messaggi',
	'SEARCH_TOPIC'				=> 'Cerca qui...',
	'SEARCH_UNANSWERED'			=> 'Argomenti senza risposta',
	'SEARCH_UNREAD'				=> 'Messaggi non letti',
	'SEARCH_USER_POSTS'			=> 'Cerca i messaggi dell’utente',
	'SECONDS'					=> 'Secondi',
	'SEE_ALL'					=> 'Vedi tutto',
	'SELECT'					=> 'Seleziona',
	'SELECT_ALL_CODE'			=> 'Seleziona tutto',
	'SELECT_DESTINATION_FORUM'	=> 'Seleziona il forum di destinazione',
	'SELECT_FORUM'				=> 'Seleziona un forum',
	'SEND_EMAIL'				=> 'Invia email',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Invia email a %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Invia messaggio privato',
	'SETTINGS'					=> 'Impostazioni',
	'SIGNATURE'					=> 'Firma',
	'SKIP'						=> 'Passa al contenuto',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Il server SMTP non supporta l’autenticazione.',
	'SORRY_AUTH_READ'			=> 'Non sei autorizzato a leggere questo forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Non sei autorizzato a scaricare questo allegato.',
	'SORT_BY'					=> 'Ordina per',
	'SORT_JOINED'				=> 'Data di registrazione',
	'SORT_LOCATION'				=> 'Località',
	'SORT_RANK'					=> 'Livello',
	'SORT_POSTS'				=> 'Messaggi',
	'SORT_TOPIC_TITLE'			=> 'Titolo argomento',
	'SORT_USERNAME'				=> 'Nome utente',
	'SPLIT_TOPIC'				=> 'Dividi argomento',
	'SQL_ERROR_OCCURRED'		=> 'Si è verificato un errore SQL richiamando questa pagina. Contatta un %samministratore%s se il problema persiste.',
	'STATISTICS'				=> 'Statistiche',
	'START_WATCHING_FORUM'		=> 'Sottoscrivi forum',
	'START_WATCHING_TOPIC'		=> 'Sottoscrivi argomento',
	'STOP_WATCHING_FORUM'		=> 'Annulla sottoscrizione forum',
	'STOP_WATCHING_TOPIC'		=> 'Annulla sottoscrizione argomento',
	'STRING_LIST_MULTI'			=> '%1$s, e %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s e %2$s',

	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforum',
	'SUBJECT'					=> 'Titolo',
	'SUBMIT'					=> 'Invia',

	'TB'						=> 'TB',
	'TERMS_USE'					=> 'Condizioni d’uso',
	'TEST_CONNECTION'			=> 'Test connessione',
	'THE_TEAM'					=> 'Staff',
	'TIB'						=> 'TiB',
	'TIME'						=> 'Ora',
	'TIMEOUT_PROCESSING_REQ'			=> 'Richiesta scaduta.',

	'TOO_LARGE'						=> 'Il valore inserito è troppo grande.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Il valore del <strong>Numero massimo di destinatari consentiti per messaggio privato</strong> inserito è troppo grande.',

	'TOO_LONG'						=> 'Il valore inserito è troppo lungo.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Il codice di conferma inserito è troppo lungo.',
	'TOO_LONG_DATEFORMAT'			=> 'Il formato della data è troppo lungo.',
	'TOO_LONG_JABBER'				=> 'Il nome account Jabber inserito è troppo lungo.',
	'TOO_LONG_NEW_PASSWORD'			=> 'La password inserita è troppo lunga.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'La password di conferma inserita è troppo lunga..',
	'TOO_LONG_USER_PASSWORD'		=> 'La password inserita è troppo lunga.',
	'TOO_LONG_USERNAME'				=> 'Il nome utente inserito è troppo lungo.',
	'TOO_LONG_EMAIL'				=> 'L’email inserita è troppo lunga.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Stai tentando di votare con troppe opzioni',

	'TOO_SHORT'						=> 'Il valore inserito è troppo corto.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Il codice di conferma inserito è troppo corto.',
	'TOO_SHORT_DATEFORMAT'			=> 'Il formato della data è troppo corto.',
	'TOO_SHORT_JABBER'				=> 'Il nome account Jabber inserito è troppo corto.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'La password inserita è troppo corta.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'La password di conferma inserita è troppo corta..',
	'TOO_SHORT_USER_PASSWORD'		=> 'La password inserita è troppo corta.',
	'TOO_SHORT_USERNAME'			=> 'Il nome utente inserito è troppo corto.',
	'TOO_SHORT_EMAIL'				=> 'L’email inserita è troppo corta.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'L’email di conferma inserita è troppo corta.',
	'TOO_SMALL'						=> 'Il valore immesso è troppo piccolo.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Il valore del <strong>numero massimo di destinatari consentiti per messaggio privato</strong> che hai inserito è troppo piccolo.',

	'TOPIC'				=> 'Argomento',
	'TOPICS'			=> 'Argomenti',
	'TOPICS_UNAPPROVED'	=> 'Almeno un argomento in questo forum non è stato approvato.',
	'TOPIC_ICON'		=> 'Icona argomento',
	'TOPIC_LOCKED'		=> 'Questo argomento è bloccato, non puoi modificare o inviare ulteriori messaggi.',
	'TOPIC_LOCKED_SHORT'=> 'Argomento bloccato',
	'TOPIC_MOVED'		=> 'Argomento spostato',
	'TOPIC_REVIEW'		=> 'Revisione argomento',
	'TOPIC_TITLE'		=> 'Titolo argomento',
	'TOPIC_UNAPPROVED'	=> 'Questo argomento non è stato approvato.',
	'TOPIC_DELETED'		=> 'Questo argomento è stato cancellato.',
	'TOTAL_ATTACHMENTS'	=> 'Allegato(i)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d log',
		2	=> '%d log',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d messaggio privato in totale',
		2	=> '%d messaggi privati in totale',
	),
	'TOPIC_POLL'		=> 'Questo argomento include un sondaggio.',
	'TOTAL_POSTS'		=> 'Totale messaggi',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Totale messaggi <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'È stata fatta una segnalazione per questo argomento',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Totale argomenti <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Totale iscritti <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Errori PHP registrati: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Impossibile determinare le dimensioni dell’immagine. Verifica che l’URL inserito sia corretto.',
	'UNABLE_TO_DELIVER_FILE'=> 'Impossibile trasportare il file.',
	'UNKNOWN_BROWSER'		=> 'Browser sconosciuto',
	'UNMARK_ALL'			=> 'Deseleziona tutto',
	'UNREAD_MESSAGES'		=> 'Messaggi non letti',
	'UNREAD_POST'			=> 'Messaggio da leggere',
	'UNREAD_POSTS'			=> 'Messaggi da leggere',
	'UNWATCH_FORUM_CONFIRM'		=> 'Sei sicuro di voler rimuovere la sottoscrizione da questo forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Sei sicuro di voler rimuovere la sottoscrizione dal forum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Sei sicuro di voler rimuovere la sottoscrizione da questo argomento?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Sei sicuro di voler rimuovere la sottoscrizione dall’argomento “%s”?',
	'UNWATCHED_FORUMS'		=> 'Non stai più controllando i forum selezionati.',
	'UNWATCHED_TOPICS'		=> 'Non stai più controllando gli argomenti selezionati.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Non stai più controllando le voci selezionati.',
	'UPDATE'				=> 'Aggiorna',
	'UPLOAD_IN_PROGRESS'	=> 'Invio in corso.',
	'URL_REDIRECT'			=> 'Se il tuo browser non supporta il redirect %sclicca qui per andare alla pagina%s.',
	'USERGROUPS'			=> 'Gruppi',
	'USERNAME'				=> 'Nome utente',
	'USERNAMES'				=> 'Nomi utente',
	'USER_AVATAR'			=> 'Avatar utente',
	'USER_CANNOT_READ'		=> 'Non puoi leggere i messaggi di questo forum.',
	'USER_POSTS'			=> array(
		1	=> '%d messaggio',
		2	=> '%d messaggi',
	),
	'USERS'					=> 'Utenti',
	'USE_PERMISSIONS'		=> 'Prova i permessi dell’utente',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Non sei autorizzato ad utilizzare questa funzione. Essendo un utente appena registrato, si richiede una tua partecipazione più attiva per utilizzare questa funzione.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Visto',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Non ancora visti',
		1	=> 'Visto %d volta',
		2	=> 'Visto %d volte',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Sta visualizzando la pagina dei contatti',
	'VIEWING_FAQ'				=> 'Sta leggendo le FAQ',
	'VIEWING_MEMBERS'			=> 'Sta visualizzando i dettagli di un iscritto',
	'VIEWING_ONLINE'			=> 'Sta visualizzando chi c’è in linea',
	'VIEWING_MCP'				=> 'Sta utilizzando il pannello di controllo moderatore',
	'VIEWING_MEMBER_PROFILE'	=> 'Sta visualizzando il profilo di un iscritto',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Sta leggendo i messaggi privati',
	'VIEWING_REGISTER'			=> 'Si sta iscrivendo',
	'VIEWING_UCP'				=> 'Sta utilizzando il pannello di controllo utente',
	'VIEWS'						=> 'Visite ',
	'VIEW_BOOKMARKS'			=> 'Vedi segnalibri',
	'VIEW_FORUM_LOGS'			=> 'Vedi log',
	'VIEW_LATEST_POST'			=> 'Vedi ultimo messaggio',
	'VIEW_NEWEST_POST'			=> 'Vedi ultimi messaggi non letti',
	'VIEW_NOTES'				=> 'Leggi note utente',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'basato sugli utenti attivi nell’ultimo %d minuto',
		2	=> 'basato sugli utenti attivi negli ultimi %d minuti',
	),
	'VIEW_TOPIC'				=> 'Leggi argomento',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annuncio: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Annuncio globale: ',
	'VIEW_TOPIC_LOCKED'			=> 'Bloccato: ',
	'VIEW_TOPIC_LOGS'			=> 'Vedi log',
	'VIEW_TOPIC_MOVED'			=> 'Spostato: ',
	'VIEW_TOPIC_POLL'			=> 'Sondaggio: ',
	'VIEW_TOPIC_STICKY'			=> 'Importante: ',
	'VISIT_WEBSITE'				=> 'Visita il sito web',

	'WARNINGS'				=> 'Richiami',
	'WARN_USER'				=> 'Richiama utente',
	'WATCH_FORUM_CONFIRM'	=> 'Sei sicuro di voler sottoscrivere questo forum?',
	'WATCH_FORUM_DETAILED'	=> 'Sei sicuro di voler sottoscrivere il forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=>'Sei sicuro di voler sottoscrivere questo argomento?',
	'WATCH_TOPIC_DETAILED'	=> 'Sei sicuro di voler sottoscrivere l’argomento “%s”?',
	'WELCOME_SUBJECT'		=> 'Benvenuto in %s',
	'WEBSITE'				=> 'Sito web',
	'WHOIS'					=> 'Whois',
	'WHO_IS_ONLINE'			=> 'Chi c’è in linea',
	'WLM'					=> 'WLM',
	'WRONG_PASSWORD'		=> 'La password inserita è errata.',

	'WRONG_DATA_COLOUR'			=> 'Il valore del colore inserito non è valido.',
	'WRONG_DATA_JABBER'			=> 'Il nome inserito non è un nome account Jabber valido.',
	'WRONG_DATA_LANG'			=> 'La lingua specificata non è valida.',
	'WRONG_DATA_POST_SD'		=> 'La direzione specificata per l’ordinamento dei messaggi non è valida.',
	'WRONG_DATA_POST_SK'		=> 'L’opzione specificata per l’ordinamento dei messaggi non è valida.',
	'WRONG_DATA_TOPIC_SD'		=> 'La direzione specificata per l’ordinamento degli argomenti non è valida.',
	'WRONG_DATA_TOPIC_SK'		=> 'L’opzione specificata per l’ordinamento degli argomenti non è valida.',
	'WROTE'						=> 'ha scritto',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Anno',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-GG)',
	'YES'				=> 'Sì',
	'YOU_LAST_VISIT'	=> 'Ultimo accesso: %s',

	'datetime'	=> array(
		'TODAY'		=> 'oggi',
		'TOMORROW'	=> 'domani',
		'YESTERDAY'	=> 'ieri',
		'AGO'		=> array(
			0	=> 'meno di un minuto fa',
			1	=> '%d minuto fa',
			2	=> '%d minuti fa',
		),

		'Sunday'	=> 'domenica',
		'Monday'	=> 'lunedì',
		'Tuesday'	=> 'martedì',
		'Wednesday'	=> 'mercoledì',
		'Thursday'	=> 'giovedì',
		'Friday'	=> 'venerdì',
		'Saturday'	=> 'sabato',

		'Sun'	=> 'dom',
		'Mon'	=> 'lun',
		'Tue'	=> 'mar',
		'Wed'	=> 'mer',
		'Thu'	=> 'gio',
		'Fri'	=> 'ven',
		'Sat'	=> 'sab',

		'January'	=> 'gennaio',
		'February'	=> 'febbraio',
		'March'		=> 'marzo',
		'April'		=> 'aprile',
		'May'		=> 'maggio',
		'June'		=> 'giugno',
		'July'		=> 'luglio',
		'August'	=> 'agosto',
		'September'	=> 'settembre',
		'October'	=> 'ottobre',
		'November'	=> 'novembre',
		'December'	=> 'dicembre',

		'Jan'		=> 'gen',
		'Feb'		=> 'feb',
		'Mar'		=> 'mar',
		'Apr'		=> 'apr',
		'May_short'	=> 'mag',
		'Jun'		=> 'giu',
		'Jul'		=> 'lug',
		'Aug'		=> 'ago',
		'Sep'		=> 'set',
		'Oct'		=> 'ott',
		'Nov'		=> 'nov',
		'Dec'		=> 'dic',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Africa/Abidjan',
		'Africa/Accra'		=> 'Africa/Accra',
		'Africa/Addis_Ababa'	=> 'Africa/Addis Ababa',
		'Africa/Algiers'	=> 'Africa/Algiers',
		'Africa/Asmara'		=> 'Africa/Asmara',
		'Africa/Bamako'		=> 'Africa/Bamako',
		'Africa/Bangui'		=> 'Africa/Bangui',
		'Africa/Banjul'		=> 'Africa/Banjul',
		'Africa/Bissau'		=> 'Africa/Bissau',
		'Africa/Blantyre'	=> 'Africa/Blantyre',
		'Africa/Brazzaville'	=> 'Africa/Brazzaville',
		'Africa/Bujumbura'	=> 'Africa/Bujumbura',
		'Africa/Cairo'		=> 'Africa/Cairo',
		'Africa/Casablanca'	=> 'Africa/Casablanca',
		'Africa/Ceuta'		=> 'Africa/Ceuta',
		'Africa/Conakry'	=> 'Africa/Conakry',
		'Africa/Dakar'		=> 'Africa/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Africa/Dar es Salaam',
		'Africa/Djibouti'	=> 'Africa/Djibouti',
		'Africa/Douala'		=> 'Africa/Douala',
		'Africa/El_Aaiun'	=> 'Africa/El Aaiun',
		'Africa/Freetown'	=> 'Africa/Freetown',
		'Africa/Gaborone'	=> 'Africa/Gaborone',
		'Africa/Harare'		=> 'Africa/Harare',
		'Africa/Johannesburg'	=> 'Africa/Johannesburg',
		'Africa/Juba'		=> 'Africa/Juba',
		'Africa/Kampala'	=> 'Africa/Kampala',
		'Africa/Khartoum'	=> 'Africa/Khartoum',
		'Africa/Kigali'		=> 'Africa/Kigali',
		'Africa/Kinshasa'	=> 'Africa/Kinshasa',
		'Africa/Lagos'		=> 'Africa/Lagos',
		'Africa/Libreville'	=> 'Africa/Libreville',
		'Africa/Lome'		=> 'Africa/Lome',
		'Africa/Luanda'		=> 'Africa/Luanda',
		'Africa/Lubumbashi'	=> 'Africa/Lubumbashi',
		'Africa/Lusaka'		=> 'Africa/Lusaka',
		'Africa/Malabo'		=> 'Africa/Malabo',
		'Africa/Maputo'		=> 'Africa/Maputo',
		'Africa/Maseru'		=> 'Africa/Maseru',
		'Africa/Mbabane'	=> 'Africa/Mbabane',
		'Africa/Mogadishu'	=> 'Africa/Mogadishu',
		'Africa/Monrovia'	=> 'Africa/Monrovia',
		'Africa/Nairobi'	=> 'Africa/Nairobi',
		'Africa/Ndjamena'	=> 'Africa/Ndjamena',
		'Africa/Niamey'		=> 'Africa/Niamey',
		'Africa/Nouakchott'	=> 'Africa/Nouakchott',
		'Africa/Ouagadougou'	=> 'Africa/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Africa/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Africa/Sao Tome',
		'Africa/Tripoli'	=> 'Africa/Tripoli',
		'Africa/Tunis'		=> 'Africa/Tunis',
		'Africa/Windhoek'	=> 'Africa/Windhoek',

		'America/Adak'		=> 'America/Adak',
		'America/Anchorage'	=> 'America/Anchorage',
		'America/Anguilla'	=> 'America/Anguilla',
		'America/Antigua'	=> 'America/Antigua',
		'America/Araguaina'	=> 'America/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'America/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'America/Argentina/Catamarca',
		'America/Argentina/Cordoba'		=> 'America/Argentina/Cordoba',
		'America/Argentina/Jujuy'		=> 'America/Argentina/Jujuy',
		'America/Argentina/La_Rioja'	=> 'America/Argentina/La Rioja',
		'America/Argentina/Mendoza'		=> 'America/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'America/Argentina/Rio Gallegos',
		'America/Argentina/Salta'		=> 'America/Argentina/Salta',
		'America/Argentina/San_Juan'	=> 'America/Argentina/San Juan',
		'America/Argentina/San_Luis'	=> 'America/Argentina/San Luis',
		'America/Argentina/Tucuman'		=> 'America/Argentina/Tucuman',
		'America/Argentina/Ushuaia'		=> 'America/Argentina/Ushuaia',

		'America/Aruba'			=> 'America/Aruba',
		'America/Asuncion'		=> 'America/Asuncion',
		'America/Atikokan'		=> 'America/Atikokan',
		'America/Bahia'			=> 'America/Bahia',
		'America/Bahia_Banderas'	=> 'America/Bahia Banderas',
		'America/Barbados'		=> 'America/Barbados',
		'America/Belem'			=> 'America/Belem',
		'America/Belize'		=> 'America/Belize',
		'America/Blanc-Sablon'	=> 'America/Blanc-Sablon',
		'America/Boa_Vista'		=> 'America/Boa Vista',
		'America/Bogota'		=> 'America/Bogota',
		'America/Boise'			=> 'America/Boise',
		'America/Cambridge_Bay'	=> 'America/Cambridge Bay',
		'America/Campo_Grande'	=> 'America/Campo Grande',
		'America/Cancun'		=> 'America/Cancun',
		'America/Caracas'		=> 'America/Caracas',
		'America/Cayenne'		=> 'America/Cayenne',
		'America/Cayman'		=> 'America/Cayman',
		'America/Chicago'		=> 'America/Chicago',
		'America/Chihuahua'		=> 'America/Chihuahua',
		'America/Costa_Rica'	=> 'America/Costa Rica',
		'America/Creston'		=> 'America/Creston',
		'America/Cuiaba'		=> 'America/Cuiaba',
		'America/Curacao'		=> 'America/Curacao',
		'America/Danmarkshavn'	=> 'America/Danmarkshavn',
		'America/Dawson'		=> 'America/Dawson',
		'America/Dawson_Creek'	=> 'America/Dawson Creek',
		'America/Denver'		=> 'America/Denver',
		'America/Detroit'		=> 'America/Detroit',
		'America/Dominica'		=> 'America/Dominica',
		'America/Edmonton'		=> 'America/Edmonton',
		'America/Eirunepe'		=> 'America/Eirunepe',
		'America/El_Salvador'	=> 'America/El Salvador',
		'America/Fortaleza'		=> 'America/Fortaleza',
		'America/Glace_Bay'		=> 'America/Glace Bay',
		'America/Godthab'		=> 'America/Godthab',
		'America/Goose_Bay'		=> 'America/Goose Bay',
		'America/Grand_Turk'	=> 'America/Grand Turk',
		'America/Grenada'		=> 'America/Grenada',
		'America/Guadeloupe'	=> 'America/Guadeloupe',
		'America/Guatemala'		=> 'America/Guatemala',
		'America/Guayaquil'		=> 'America/Guayaquil',
		'America/Guyana'		=> 'America/Guyana',
		'America/Halifax'		=> 'America/Halifax',
		'America/Havana'		=> 'America/Havana',
		'America/Hermosillo'		=> 'America/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'America/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'America/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'America/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'America/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'America/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'America/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'America/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'America/Indiana/Winamac',
		'America/Inuvik'		=> 'America/Inuvik',
		'America/Iqaluit'		=> 'America/Iqaluit',
		'America/Jamaica'		=> 'America/Jamaica',
		'America/Juneau'		=> 'America/Juneau',
		'America/Kentucky/Louisville'	=> 'America/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'America/Kentucky/Monticello',
		'America/Kralendijk'	=> 'America/Kralendijk',
		'America/La_Paz'		=> 'America/La Paz',
		'America/Lima'			=> 'America/Lima',
		'America/Los_Angeles'	=> 'America/Los Angeles',
		'America/Lower_Princes'	=> 'America/Lower Princes',
		'America/Maceio'		=> 'America/Maceio',
		'America/Managua'		=> 'America/Managua',
		'America/Manaus'		=> 'America/Manaus',
		'America/Marigot'		=> 'America/Marigot',
		'America/Martinique'	=> 'America/Martinique',
		'America/Matamoros'		=> 'America/Matamoros',
		'America/Mazatlan'		=> 'America/Mazatlan',
		'America/Menominee'		=> 'America/Menominee',
		'America/Merida'		=> 'America/Merida',
		'America/Metlakatla'	=> 'America/Metlakatla',
		'America/Mexico_City'	=> 'America/Mexico City',
		'America/Miquelon'		=> 'America/Miquelon',
		'America/Moncton'		=> 'America/Moncton',
		'America/Monterrey'		=> 'America/Monterrey',
		'America/Montevideo'	=> 'America/Montevideo',
		'America/Montreal'		=> 'America/Montreal',
		'America/Montserrat'	=> 'America/Montserrat',
		'America/Nassau'		=> 'America/Nassau',
		'America/New_York'		=> 'America/New York',
		'America/Nipigon'		=> 'America/Nipigon',
		'America/Nome'			=> 'America/Nome',
		'America/Noronha'		=> 'America/Noronha',
		'America/North_Dakota/Beulah'		=> 'America/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'America/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'America/North Dakota/New Salem',
		'America/Ojinaga'		=> 'America/Ojinaga',
		'America/Panama'		=> 'America/Panama',
		'America/Pangnirtung'	=> 'America/Pangnirtung',
		'America/Paramaribo'	=> 'America/Paramaribo',
		'America/Phoenix'		=> 'America/Phoenix',
		'America/Port-au-Prince'	=> 'America/Port-au-Prince',
		'America/Port_of_Spain'	=> 'America/Port of Spain',
		'America/Porto_Velho'	=> 'America/Porto Velho',
		'America/Puerto_Rico'	=> 'America/Puerto Rico',
		'America/Rainy_River'	=> 'America/Rainy River',
		'America/Rankin_Inlet'	=> 'America/Rankin Inlet',
		'America/Recife'		=> 'America/Recife',
		'America/Regina'		=> 'America/Regina',
		'America/Resolute'		=> 'America/Resolute',
		'America/Rio_Branco'	=> 'America/Rio Branco',
		'America/Santa_Isabel'	=> 'America/Santa Isabel',
		'America/Santarem'		=> 'America/Santarem',
		'America/Santiago'		=> 'America/Santiago',
		'America/Santo_Domingo'	=> 'America/Santo Domingo',
		'America/Sao_Paulo'		=> 'America/Sao Paulo',
		'America/Scoresbysund'	=> 'America/Scoresbysund',
		'America/Shiprock'		=> 'America/Shiprock',
		'America/Sitka'			=> 'America/Sitka',
		'America/St_Barthelemy'	=> 'America/St. Barthelemy',
		'America/St_Johns'		=> 'America/St. Johns',
		'America/St_Kitts'		=> 'America/St. Kitts',
		'America/St_Lucia'		=> 'America/St. Lucia',
		'America/St_Thomas'		=> 'America/St. Thomas',
		'America/St_Vincent'	=> 'America/St. Vincent',
		'America/Swift_Current'	=> 'America/Swift Current',
		'America/Tegucigalpa'	=> 'America/Tegucigalpa',
		'America/Thule'			=> 'America/Thule',
		'America/Thunder_Bay'	=> 'America/Thunder Bay',
		'America/Tijuana'		=> 'America/Tijuana',
		'America/Toronto'		=> 'America/Toronto',
		'America/Tortola'		=> 'America/Tortola',
		'America/Vancouver'		=> 'America/Vancouver',
		'America/Whitehorse'	=> 'America/Whitehorse',
		'America/Winnipeg'		=> 'America/Winnipeg',
		'America/Yakutat'		=> 'America/Yakutat',
		'America/Yellowknife'	=> 'America/Yellowknife',

		'Antarctica/Casey'		=> 'Antarctica/Casey',
		'Antarctica/Davis'		=> 'Antarctica/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antarctica/Macquarie',
		'Antarctica/Mawson'		=> 'Antarctica/Mawson',
		'Antarctica/McMurdo'	=> 'Antarctica/McMurdo',
		'Antarctica/Palmer'		=> 'Antarctica/Palmer',
		'Antarctica/Rothera'	=> 'Antarctica/Rothera',
		'Antarctica/South_Pole'	=> 'Antarctica/South Pole',
		'Antarctica/Syowa'		=> 'Antarctica/Syowa',
		'Antarctica/Vostok'		=> 'Antarctica/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctic/Longyearbyen',

		'Asia/Aden'			=> 'Asia/Aden',
		'Asia/Almaty'		=> 'Asia/Almaty',
		'Asia/Amman'		=> 'Asia/Amman',
		'Asia/Anadyr'		=> 'Asia/Anadyr',
		'Asia/Aqtau'		=> 'Asia/Aqtau',
		'Asia/Aqtobe'		=> 'Asia/Aqtobe',
		'Asia/Ashgabat'		=> 'Asia/Ashgabat',
		'Asia/Baghdad'		=> 'Asia/Baghdad',
		'Asia/Bahrain'		=> 'Asia/Bahrain',
		'Asia/Baku'			=> 'Asia/Baku',
		'Asia/Bangkok'		=> 'Asia/Bangkok',
		'Asia/Beirut'		=> 'Asia/Beirut',
		'Asia/Bishkek'		=> 'Asia/Bishkek',
		'Asia/Brunei'		=> 'Asia/Brunei',
		'Asia/Choibalsan'	=> 'Asia/Choibalsan',
		'Asia/Chongqing'	=> 'Asia/Chongqing',
		'Asia/Colombo'		=> 'Asia/Colombo',
		'Asia/Damascus'		=> 'Asia/Damascus',
		'Asia/Dhaka'		=> 'Asia/Dhaka',
		'Asia/Dili'			=> 'Asia/Dili',
		'Asia/Dubai'		=> 'Asia/Dubai',
		'Asia/Dushanbe'		=> 'Asia/Dushanbe',
		'Asia/Gaza'			=> 'Asia/Gaza',
		'Asia/Harbin'		=> 'Asia/Harbin',
		'Asia/Hebron'		=> 'Asia/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Asia/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Asia/Hong Kong',
		'Asia/Hovd'			=> 'Asia/Hovd',
		'Asia/Irkutsk'		=> 'Asia/Irkutsk',
		'Asia/Jakarta'		=> 'Asia/Jakarta',
		'Asia/Jayapura'		=> 'Asia/Jayapura',
		'Asia/Jerusalem'	=> 'Asia/Jerusalem',
		'Asia/Kabul'		=> 'Asia/Kabul',
		'Asia/Kamchatka'	=> 'Asia/Kamchatka',
		'Asia/Karachi'		=> 'Asia/Karachi',
		'Asia/Kashgar'		=> 'Asia/Kashgar',
		'Asia/Kathmandu'	=> 'Asia/Kathmandu',
		'Asia/Khandyga'		=> 'Asia/Khandyga',
		'Asia/Kolkata'		=> 'Asia/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Asia/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Asia/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asia/Kuching',
		'Asia/Kuwait'		=> 'Asia/Kuwait',
		'Asia/Macau'		=> 'Asia/Macau',
		'Asia/Magadan'		=> 'Asia/Magadan',
		'Asia/Makassar'		=> 'Asia/Makassar',
		'Asia/Manila'		=> 'Asia/Manila',
		'Asia/Muscat'		=> 'Asia/Muscat',
		'Asia/Nicosia'		=> 'Asia/Nicosia',
		'Asia/Novokuznetsk'	=> 'Asia/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Asia/Novosibirsk',
		'Asia/Omsk'			=> 'Asia/Omsk',
		'Asia/Oral'			=> 'Asia/Oral',
		'Asia/Phnom_Penh'	=> 'Asia/Phnom Penh',
		'Asia/Pontianak'	=> 'Asia/Pontianak',
		'Asia/Pyongyang'	=> 'Asia/Pyongyang',
		'Asia/Qatar'		=> 'Asia/Qatar',
		'Asia/Qyzylorda'	=> 'Asia/Qyzylorda',
		'Asia/Rangoon'		=> 'Asia/Rangoon',
		'Asia/Riyadh'		=> 'Asia/Riyadh',
		'Asia/Sakhalin'		=> 'Asia/Sakhalin',
		'Asia/Samarkand'	=> 'Asia/Samarkand',
		'Asia/Seoul'		=> 'Asia/Seoul',
		'Asia/Shanghai'		=> 'Asia/Shanghai',
		'Asia/Singapore'	=> 'Asia/Singapore',
		'Asia/Taipei'		=> 'Asia/Taipei',
		'Asia/Tashkent'		=> 'Asia/Tashkent',
		'Asia/Tbilisi'		=> 'Asia/Tbilisi',
		'Asia/Tehran'		=> 'Asia/Tehran',
		'Asia/Thimphu'		=> 'Asia/Thimphu',
		'Asia/Tokyo'		=> 'Asia/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Asia/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Asia/Urumqi',
		'Asia/Ust-Nera'		=> 'Asia/Ust-Nera',
		'Asia/Vientiane'	=> 'Asia/Vientiane',
		'Asia/Vladivostok'	=> 'Asia/Vladivostok',
		'Asia/Yakutsk'		=> 'Asia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asia/Yekaterinburg',
		'Asia/Yerevan'		=> 'Asia/Yerevan',

		'Atlantic/Azores'		=> 'Atlantic/Azores',
		'Atlantic/Bermuda'		=> 'Atlantic/Bermuda',
		'Atlantic/Canary'		=> 'Atlantic/Canary',
		'Atlantic/Cape_Verde'	=> 'Atlantic/Cape Verde',
		'Atlantic/Faroe'		=> 'Atlantic/Faroe',
		'Atlantic/Madeira'		=> 'Atlantic/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlantic/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantic/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlantic/St. Helena',
		'Atlantic/Stanley'		=> 'Atlantic/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelaide',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'	=> 'Europe/Amsterdam',
		'Europe/Andorra'	=> 'Europe/Andorra',
		'Europe/Athens'		=> 'Europe/Athens',
		'Europe/Belgrade'	=> 'Europe/Belgrade',
		'Europe/Berlin'		=> 'Europe/Berlin',
		'Europe/Bratislava'	=> 'Europe/Bratislava',
		'Europe/Brussels'	=> 'Europe/Brussels',
		'Europe/Bucharest'	=> 'Europe/Bucharest',
		'Europe/Budapest'	=> 'Europe/Budapest',
		'Europe/Busingen'	=> 'Europe/Busingen',
		'Europe/Chisinau'	=> 'Europe/Chisinau',
		'Europe/Copenhagen'	=> 'Europe/Copenhagen',
		'Europe/Dublin'		=> 'Europe/Dublin',
		'Europe/Gibraltar'	=> 'Europe/Gibraltar',
		'Europe/Guernsey'	=> 'Europe/Guernsey',
		'Europe/Helsinki'	=> 'Europe/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europe/Isle of Man',
		'Europe/Istanbul'	=> 'Europe/Istanbul',
		'Europe/Jersey'		=> 'Europe/Jersey',
		'Europe/Kaliningrad'	=> 'Europe/Kaliningrad',
		'Europe/Kiev'		=> 'Europe/Kiev',
		'Europe/Lisbon'		=> 'Europe/Lisbon',
		'Europe/Ljubljana'	=> 'Europe/Ljubljana',
		'Europe/London'		=> 'Europe/London',
		'Europe/Luxembourg'	=> 'Europe/Luxembourg',
		'Europe/Madrid'		=> 'Europe/Madrid',
		'Europe/Malta'		=> 'Europe/Malta',
		'Europe/Mariehamn'	=> 'Europe/Mariehamn',
		'Europe/Minsk'		=> 'Europe/Minsk',
		'Europe/Monaco'		=> 'Europe/Monaco',
		'Europe/Moscow'		=> 'Europe/Moscow',
		'Europe/Oslo'		=> 'Europe/Oslo',
		'Europe/Paris'		=> 'Europe/Paris',
		'Europe/Podgorica'	=> 'Europe/Podgorica',
		'Europe/Prague'		=> 'Europe/Prague',
		'Europe/Riga'		=> 'Europe/Riga',
		'Europe/Rome'		=> 'Europa/Roma',
		'Europe/Samara'		=> 'Europe/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europe/Sarajevo',
		'Europe/Simferopol'	=> 'Europe/Simferopol',
		'Europe/Skopje'		=> 'Europe/Skopje',
		'Europe/Sofia'		=> 'Europe/Sofia',
		'Europe/Stockholm'	=> 'Europe/Stockholm',
		'Europe/Tallinn'	=> 'Europe/Tallinn',
		'Europe/Tirane'		=> 'Europe/Tirane',
		'Europe/Uzhgorod'	=> 'Europe/Uzhgorod',
		'Europe/Vaduz'		=> 'Europe/Vaduz',
		'Europe/Vatican'	=> 'Europa/Vaticano',
		'Europe/Vienna'		=> 'Europe/Vienna',
		'Europe/Vilnius'	=> 'Europe/Vilnius',
		'Europe/Volgograd'	=> 'Europe/Volgograd',
		'Europe/Warsaw'		=> 'Europe/Warsaw',
		'Europe/Zagreb'		=> 'Europe/Zagreb',
		'Europe/Zaporozhye'	=> 'Europe/Zaporozhye',
		'Europe/Zurich'		=> 'Europe/Zurich',

		'Indian/Antananarivo'	=> 'Indian/Antananarivo',
		'Indian/Chagos'		=> 'Indian/Chagos',
		'Indian/Christmas'	=> 'Indian/Christmas',
		'Indian/Cocos'		=> 'Indian/Cocos',
		'Indian/Comoro'		=> 'Indian/Comoro',
		'Indian/Kerguelen'	=> 'Indian/Kerguelen',
		'Indian/Mahe'		=> 'Indian/Mahe',
		'Indian/Maldives'	=> 'Indian/Maldives',
		'Indian/Mauritius'	=> 'Indian/Mauritius',
		'Indian/Mayotte'	=> 'Indian/Mayotte',
		'Indian/Reunion'	=> 'Indian/Reunion',

		'Pacific/Apia'		=> 'Pacific/Apia',
		'Pacific/Auckland'	=> 'Pacific/Auckland',
		'Pacific/Chatham'	=> 'Pacific/Chatham',
		'Pacific/Chuuk'		=> 'Pacific/Chuuk',
		'Pacific/Easter'	=> 'Pacific/Easter',
		'Pacific/Efate'		=> 'Pacific/Efate',
		'Pacific/Enderbury'	=> 'Pacific/Enderbury',
		'Pacific/Fakaofo'	=> 'Pacific/Fakaofo',
		'Pacific/Fiji'		=> 'Pacific/Fiji',
		'Pacific/Funafuti'	=> 'Pacific/Funafuti',
		'Pacific/Galapagos'	=> 'Pacific/Galapagos',
		'Pacific/Gambier'	=> 'Pacific/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacific/Guadalcanal',
		'Pacific/Guam'		=> 'Pacific/Guam',
		'Pacific/Honolulu'	=> 'Pacific/Honolulu',
		'Pacific/Johnston'	=> 'Pacific/Johnston',
		'Pacific/Kiritimati'	=> 'Pacific/Kiritimati',
		'Pacific/Kosrae'	=> 'Pacific/Kosrae',
		'Pacific/Kwajalein'	=> 'Pacific/Kwajalein',
		'Pacific/Majuro'	=> 'Pacific/Majuro',
		'Pacific/Marquesas'	=> 'Pacific/Marquesas',
		'Pacific/Midway'	=> 'Pacific/Midway',
		'Pacific/Nauru'		=> 'Pacific/Nauru',
		'Pacific/Niue'		=> 'Pacific/Niue',
		'Pacific/Norfolk'	=> 'Pacific/Norfolk',
		'Pacific/Noumea'	=> 'Pacific/Noumea',
		'Pacific/Pago_Pago'	=> 'Pacific/Pago Pago',
		'Pacific/Palau'		=> 'Pacific/Palau',
		'Pacific/Pitcairn'	=> 'Pacific/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pacific/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacific/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pacific/Rarotonga',
		'Pacific/Saipan'	=> 'Pacific/Saipan',
		'Pacific/Tahiti'	=> 'Pacific/Tahiti',
		'Pacific/Tarawa'	=> 'Pacific/Tarawa',
		'Pacific/Tongatapu'	=> 'Pacific/Tongatapu',
		'Pacific/Wake'		=> 'Pacific/Wake',
		'Pacific/Wallis'	=> 'Pacific/Wallis',

	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd/m/Y, G:i'		=> '08/12/2007, 13:15',
		'|d/m/Y|, G:i'		=> '08/12/2007, 13:15 / oggi, 13:15',
		'j M Y, G:i'		=> '8 dic 2007, 13:37',
		'|j M Y|, G:i'		=> '8 dic 2007, 13:37 / oggi, 13:15',
		'j F Y, G:i'		=> '8 dicembre 2007, 13:15',
		'|j F Y|, G:i'		=> '8 dicembre 2007, 13:15 / oggi, 13:15',
		'D j M Y, G:i'		=> 'sab 8 dic 2007, 13:15',
		'|D j M Y|, G:i'	=> 'sab 8 dic 2007, 13:15 / oggi, 13:15',
		'l j F Y, G:i'		=> 'sabato 8 dicembre 2007, 13:15',
		'|l j F Y|, G:i'	=> 'sabato 8 dicembre 2007, 13:15 / oggi, 13:15'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> '|d/m/Y|, G:i', // 08/12/2007, 13:15 / oggi, 13:15
));
